/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.client.BaseMetaStoreClient;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.CatalogUtils;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.hive.MetastoreUtil;
import org.apache.iceberg.hive.RuntimeMetaException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRESTCatalogClient
extends BaseMetaStoreClient {
    public static final String NAMESPACE_SEPARATOR = ".";
    public static final String DB_OWNER = "owner";
    public static final String DB_OWNER_TYPE = "ownerType";
    private static final Logger LOG = LoggerFactory.getLogger(HiveRESTCatalogClient.class);
    private RESTCatalog restCatalog;

    public HiveRESTCatalogClient(Configuration conf, boolean allowEmbedded) {
        this(conf);
    }

    public HiveRESTCatalogClient(Configuration conf) {
        super(conf);
        this.reconnect();
    }

    public void reconnect() {
        this.close();
        String catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        Map<String, String> properties = CatalogUtils.getCatalogProperties(this.conf, CatalogUtils.getCatalogName(this.conf));
        this.restCatalog = (RESTCatalog)CatalogUtil.buildIcebergCatalog((String)catName, properties, null);
    }

    public void close() {
        try {
            if (this.restCatalog != null) {
                this.restCatalog.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeMetaException(e.getCause(), "Failed to close existing REST catalog", new Object[0]);
        }
    }

    public List<String> getDatabases(String catName, String dbPattern) {
        this.validateCurrentCatalog(catName);
        String regex = dbPattern.replace("*", ".*");
        Pattern pattern = Pattern.compile(regex);
        return this.restCatalog.listNamespaces(Namespace.empty()).stream().map(Namespace::toString).filter(pattern.asPredicate()).toList();
    }

    public List<String> getAllDatabases(String catName) {
        return this.getDatabases(catName, "*");
    }

    public List<String> getTables(String catName, String dbName, String tablePattern) {
        this.validateCurrentCatalog(catName);
        String regex = tablePattern.replace("*", ".*");
        Pattern pattern = Pattern.compile(regex);
        return this.restCatalog.listTables(Namespace.of((String[])new String[]{dbName})).stream().map(TableIdentifier::name).filter(pattern.asPredicate()).toList();
    }

    public List<String> getAllTables(String catName, String dbName) {
        return this.getTables(catName, dbName, "*");
    }

    public void dropTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws TException {
        this.restCatalog.dropTable(TableIdentifier.of((String[])new String[]{table.getDbName(), table.getTableName()}));
    }

    private void validateCurrentCatalog(String catName) {
        if (!this.restCatalog.name().equals(catName)) {
            throw new IllegalArgumentException(String.format("Catalog name '%s' does not match the current catalog '%s'", catName, this.restCatalog.name()));
        }
    }

    public boolean tableExists(String catName, String dbName, String tableName) {
        this.validateCurrentCatalog(catName);
        return this.restCatalog.tableExists(TableIdentifier.of((String[])new String[]{dbName, tableName}));
    }

    public Database getDatabase(String catName, String dbName) throws NoSuchObjectException {
        this.validateCurrentCatalog(catName);
        return this.restCatalog.listNamespaces(Namespace.empty()).stream().filter(namespace -> namespace.levels()[0].equals(dbName)).map(namespace -> {
            Database database = new Database();
            database.setName(String.join((CharSequence)NAMESPACE_SEPARATOR, namespace.levels()));
            Map namespaceMetadata = this.restCatalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{dbName}));
            database.setLocationUri((String)namespaceMetadata.get("location"));
            database.setCatalogName(this.restCatalog.name());
            database.setOwnerName((String)namespaceMetadata.get(DB_OWNER));
            try {
                database.setOwnerType(PrincipalType.valueOf((String)((String)namespaceMetadata.get(DB_OWNER_TYPE))));
            }
            catch (Exception e) {
                LOG.warn("Can not set ownerType: {}", namespaceMetadata.get(DB_OWNER_TYPE), (Object)e);
            }
            return database;
        }).findFirst().orElseThrow(() -> new NoSuchObjectException("Database " + dbName + " not found"));
    }

    public org.apache.hadoop.hive.metastore.api.Table getTable(GetTableRequest tableRequest) throws TException {
        Table icebergTable;
        this.validateCurrentCatalog(tableRequest.getCatName());
        try {
            icebergTable = this.restCatalog.loadTable(TableIdentifier.of((String[])new String[]{tableRequest.getDbName(), tableRequest.getTblName()}));
        }
        catch (NoSuchTableException exception) {
            throw new NoSuchObjectException();
        }
        return MetastoreUtil.toHiveTable(icebergTable, this.conf);
    }

    public void createTable(CreateTableRequest request) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = request.getTable();
        ArrayList cols = Lists.newArrayList((Iterable)table.getSd().getCols());
        if (table.isSetPartitionKeys() && !table.getPartitionKeys().isEmpty()) {
            cols.addAll(table.getPartitionKeys());
        }
        Properties catalogProperties = CatalogUtils.getCatalogProperties(table);
        Schema schema = HiveSchemaUtil.convert(cols, Collections.emptyMap(), true);
        Map<String, String> envCtxProps = Optional.ofNullable(request.getEnvContext()).map(EnvironmentContext::getProperties).orElse(Collections.emptyMap());
        PartitionSpec partitionSpec = HMSTablePropertyHelper.getPartitionSpec(envCtxProps, schema);
        SortOrder sortOrder = HMSTablePropertyHelper.getSortOrder(catalogProperties, schema);
        this.restCatalog.buildTable(TableIdentifier.of((String[])new String[]{table.getDbName(), table.getTableName()}), schema).withPartitionSpec(partitionSpec).withLocation(catalogProperties.getProperty("location")).withSortOrder(sortOrder).withProperties((Map)Maps.fromProperties((Properties)catalogProperties)).create();
    }

    public void createDatabase(Database db) {
        this.validateCurrentCatalog(db.getCatalogName());
        ImmutableMap props = ImmutableMap.of((Object)"location", (Object)db.getLocationUri(), (Object)DB_OWNER, (Object)db.getOwnerName(), (Object)DB_OWNER_TYPE, (Object)db.getOwnerType().toString());
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{db.getName()}), (Map)props);
    }

    public void dropDatabase(DropDatabaseRequest req) {
        this.validateCurrentCatalog(req.getCatalogName());
        this.restCatalog.dropNamespace(Namespace.of((String[])new String[]{req.getName()}));
    }

    public List<org.apache.hadoop.hive.metastore.api.Table> getAllMaterializedViewObjectsForRewriting() {
        return Collections.emptyList();
    }

    public List<String> getMaterializedViewsForRewriting(String catName, String dbName) {
        return Collections.emptyList();
    }
}

