/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class CatalogUtils {
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String CATALOG_NAME = "iceberg.catalog";
    public static final String CATALOG_CONFIG_PREFIX = "iceberg.catalog.";
    public static final String CATALOG_WAREHOUSE_TEMPLATE = "iceberg.catalog.%s.warehouse";
    public static final String CATALOG_IMPL_TEMPLATE = "iceberg.catalog.%s.catalog-impl";
    public static final String CATALOG_DEFAULT_CONFIG_PREFIX = "iceberg.catalog-default.";
    public static final String ICEBERG_HADOOP_TABLE_NAME = "location_based_table";
    public static final String ICEBERG_DEFAULT_CATALOG_NAME = "default_iceberg";
    public static final String NO_CATALOG_TYPE = "no catalog";
    public static final Set<String> PROPERTIES_TO_REMOVE = ImmutableSet.of((Object)"metadata_location", (Object)"previous_metadata_location");

    private CatalogUtils() {
    }

    public static Properties getCatalogProperties(Table hmsTable) {
        SerDeInfo serdeInfo;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)CatalogUtils.toIcebergProperties(hmsTable.getParameters()));
        if (properties.get(LOCATION) == null && hmsTable.getSd() != null && hmsTable.getSd().getLocation() != null) {
            properties.put(LOCATION, hmsTable.getSd().getLocation());
        }
        if (properties.get(NAME) == null) {
            properties.put(NAME, TableIdentifier.of((String[])new String[]{hmsTable.getDbName(), hmsTable.getTableName()}).toString());
        }
        if ((serdeInfo = hmsTable.getSd().getSerdeInfo()) != null) {
            properties.putAll((Map<?, ?>)CatalogUtils.toIcebergProperties(serdeInfo.getParameters()));
        }
        PROPERTIES_TO_REMOVE.forEach(properties::remove);
        return properties;
    }

    private static Properties toIcebergProperties(Map<String, String> parameters) {
        Properties properties = new Properties();
        parameters.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).forEach(e -> {
            String icebergKey = HMSTablePropertyHelper.translateToIcebergProp((String)e.getKey());
            properties.put(icebergKey, e.getValue());
        });
        return properties;
    }

    public static Map<String, String> getCatalogProperties(Configuration conf, String catalogName) {
        HashMap catalogProperties = Maps.newHashMap();
        String keyPrefix = CATALOG_CONFIG_PREFIX + catalogName;
        conf.forEach(config -> {
            if (((String)config.getKey()).startsWith(CATALOG_DEFAULT_CONFIG_PREFIX)) {
                catalogProperties.putIfAbsent(((String)config.getKey()).substring(CATALOG_DEFAULT_CONFIG_PREFIX.length()), (String)config.getValue());
            } else if (((String)config.getKey()).startsWith(keyPrefix)) {
                catalogProperties.put(((String)config.getKey()).substring(keyPrefix.length() + 1), (String)config.getValue());
            }
        });
        return catalogProperties;
    }

    public static String getCatalogName(Configuration conf) {
        return MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_DEFAULT);
    }

    public static String getCatalogType(Configuration conf) {
        return CatalogUtils.getCatalogType(conf, CatalogUtils.getCatalogName(conf));
    }

    public static boolean isHadoopTable(Configuration conf, Properties catalogProperties) {
        String catalogName = catalogProperties.getProperty(CATALOG_NAME);
        return ICEBERG_HADOOP_TABLE_NAME.equals(catalogName) || CatalogUtils.hadoopCatalog(conf, catalogProperties);
    }

    public static boolean hadoopCatalog(Configuration conf, Properties props) {
        return CatalogUtils.assertCatalogType(conf, props, "hadoop", "org.apache.iceberg.hadoop.HadoopCatalog");
    }

    public static String catalogPropertyConfigKey(String catalogName, String catalogProperty) {
        return String.format("%s%s.%s", CATALOG_CONFIG_PREFIX, catalogName, catalogProperty);
    }

    public static String getCatalogType(Configuration conf, String catalogName) {
        if (!StringUtils.isEmpty((CharSequence)catalogName)) {
            String catalogType = conf.get(CatalogUtils.catalogPropertyConfigKey(catalogName, "type"));
            if (catalogName.equals(ICEBERG_HADOOP_TABLE_NAME)) {
                return NO_CATALOG_TYPE;
            }
            return catalogType;
        }
        String catalogType = conf.get("type");
        if (catalogType != null && catalogType.equals(LOCATION)) {
            return NO_CATALOG_TYPE;
        }
        return catalogType;
    }

    public static String getCatalogImpl(Configuration conf, String catalogName) {
        return Optional.ofNullable(catalogName).filter(StringUtils::isNotEmpty).map(name -> String.format(CATALOG_IMPL_TEMPLATE, name)).map(arg_0 -> ((Configuration)conf).get(arg_0)).orElse(null);
    }

    public static boolean assertCatalogType(Configuration conf, Properties props, String expectedType, String expectedImpl) {
        String catalogName = props.getProperty(CATALOG_NAME);
        String catalogType = Optional.ofNullable(CatalogUtils.getCatalogType(conf, catalogName)).orElseGet(() -> CatalogUtils.getCatalogType(conf, ICEBERG_DEFAULT_CATALOG_NAME));
        if (catalogType != null) {
            return expectedType.equalsIgnoreCase(catalogType);
        }
        String actualImpl = CatalogUtils.getCatalogProperties(conf, catalogName).get("catalog-impl");
        if (StringUtils.equals((CharSequence)expectedImpl, (CharSequence)actualImpl)) {
            return true;
        }
        if (expectedImpl == null || actualImpl == null) {
            return false;
        }
        try {
            return Class.forName(expectedImpl).isAssignableFrom(Class.forName(actualImpl));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Error checking if catalog %s is subtype of %s", catalogName, expectedImpl), e);
        }
    }
}

