/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class BinaryUtil {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    private BinaryUtil() {
    }

    public static ByteBuffer truncateBinary(ByteBuffer input, int length) {
        Preconditions.checkArgument(length >= 0, "Truncate length should be non-negative");
        if (length == 0) {
            return EMPTY_BYTE_BUFFER;
        }
        if (length >= input.remaining()) {
            return input;
        }
        byte[] array = new byte[length];
        input.duplicate().get(array);
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer truncateBinaryUnsafe(ByteBuffer value, int width) {
        ByteBuffer ret = value.duplicate();
        ret.limit(Math.min(value.limit(), value.position() + width));
        return ret;
    }

    public static Literal<ByteBuffer> truncateBinaryMin(Literal<ByteBuffer> input, int length) {
        ByteBuffer inputBuffer = input.value();
        if (length >= inputBuffer.remaining()) {
            return input;
        }
        return Literal.of(BinaryUtil.truncateBinary(inputBuffer, length));
    }

    public static ByteBuffer truncateBinaryMin(ByteBuffer input, int length) {
        return BinaryUtil.truncateBinary(input, length);
    }

    public static Literal<ByteBuffer> truncateBinaryMax(Literal<ByteBuffer> input, int length) {
        ByteBuffer truncated = BinaryUtil.truncateBinaryMax(input.value(), length);
        return truncated != null ? Literal.of(truncated) : null;
    }

    public static ByteBuffer truncateBinaryMax(ByteBuffer inputBuffer, int length) {
        if (length >= inputBuffer.remaining()) {
            return inputBuffer;
        }
        ByteBuffer truncatedInput = BinaryUtil.truncateBinary(inputBuffer, length);
        for (int i = length - 1; i >= 0; --i) {
            byte element = truncatedInput.get(i);
            if ((element = (byte)(element + 1)) == 0) continue;
            truncatedInput.put(i, element);
            truncatedInput.position(0);
            truncatedInput.limit(i + 1);
            return truncatedInput;
        }
        return null;
    }
}

