/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public final class IcebergDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveDecimalObjectInspector,
WriteObjectInspector {
    private static final Cache<Integer, IcebergDecimalObjectInspector> CACHE = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public static IcebergDecimalObjectInspector get(int precision, int scale) {
        Preconditions.checkArgument(scale <= precision);
        Preconditions.checkArgument(precision <= 38);
        Preconditions.checkArgument(scale <= 38);
        Integer key = precision << 8 | scale;
        return CACHE.get(key, k -> new IcebergDecimalObjectInspector(precision, scale));
    }

    private IcebergDecimalObjectInspector(int precision, int scale) {
        super((PrimitiveTypeInfo)new DecimalTypeInfo(precision, scale));
    }

    public HiveDecimal getPrimitiveJavaObject(Object o) {
        return o == null ? null : HiveDecimal.create((BigDecimal)((BigDecimal)o));
    }

    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        HiveDecimal decimal = this.getPrimitiveJavaObject(o);
        return decimal == null ? null : new HiveDecimalWritable(decimal);
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof HiveDecimal) {
            HiveDecimal decimal = (HiveDecimal)o;
            return HiveDecimal.create((BigDecimal)decimal.bigDecimalValue());
        }
        if (o instanceof BigDecimal) {
            BigDecimal copy = new BigDecimal(o.toString());
            return copy;
        }
        return o;
    }

    @Override
    public BigDecimal convert(Object o) {
        if (o == null) {
            return null;
        }
        BigDecimal result = ((HiveDecimal)o).bigDecimalValue();
        result = result.setScale(this.scale());
        return result;
    }
}

