/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator.amoro;

import java.util.Map;
import org.apache.iceberg.util.PropertyUtil;

public class CompatiblePropertyUtil {
    private CompatiblePropertyUtil() {
    }

    public static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(properties, CompatiblePropertyUtil.getCompatibleProperty(properties, property), defaultValue);
    }

    public static double propertyAsDouble(Map<String, String> properties, String property, double defaultValue) {
        return PropertyUtil.propertyAsDouble(properties, CompatiblePropertyUtil.getCompatibleProperty(properties, property), defaultValue);
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(properties, CompatiblePropertyUtil.getCompatibleProperty(properties, property), defaultValue);
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(properties, CompatiblePropertyUtil.getCompatibleProperty(properties, property), defaultValue);
    }

    private static String getCompatibleProperty(Map<String, String> properties, String property) {
        String legacyProperty = CompatiblePropertyUtil.getLegacyProperty(property);
        if (legacyProperty != null && properties.containsKey(legacyProperty) && !properties.containsKey(property)) {
            return legacyProperty;
        }
        return property;
    }

    private static String getLegacyProperty(String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "self-optimizing.enabled": {
                return "optimize.enable";
            }
            case "self-optimizing.minor.trigger.file-count": {
                return "optimize.minor.trigger.delete-file-count";
            }
            case "self-optimizing.minor.trigger.interval": {
                return "optimize.minor.trigger.max-interval";
            }
            case "self-optimizing.full.trigger.interval": {
                return "optimize.full.trigger.max-interval";
            }
        }
        return null;
    }
}

