/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.view.ViewMetadata;

public interface UpdateRequirement {
    default public void validate(TableMetadata base) {
        throw new ValidationException("Cannot validate %s against a table", this.getClass().getSimpleName());
    }

    default public void validate(ViewMetadata base) {
        throw new ValidationException("Cannot validate %s against a view", this.getClass().getSimpleName());
    }

    public static class AssertDefaultSortOrderID
    implements UpdateRequirement {
        private final int sortOrderId;

        public AssertDefaultSortOrderID(int sortOrderId) {
            this.sortOrderId = sortOrderId;
        }

        public int sortOrderId() {
            return this.sortOrderId;
        }

        @Override
        public void validate(TableMetadata base) {
            if (this.sortOrderId != base.defaultSortOrderId()) {
                throw new CommitFailedException("Requirement failed: default sort order changed: expected id %s != %s", this.sortOrderId, base.defaultSortOrderId());
            }
        }
    }

    public static class AssertDefaultSpecID
    implements UpdateRequirement {
        private final int specId;

        public AssertDefaultSpecID(int specId) {
            this.specId = specId;
        }

        public int specId() {
            return this.specId;
        }

        @Override
        public void validate(TableMetadata base) {
            if (this.specId != base.defaultSpecId()) {
                throw new CommitFailedException("Requirement failed: default partition spec changed: expected id %s != %s", this.specId, base.defaultSpecId());
            }
        }
    }

    public static class AssertLastAssignedPartitionId
    implements UpdateRequirement {
        private final int lastAssignedPartitionId;

        public AssertLastAssignedPartitionId(int lastAssignedPartitionId) {
            this.lastAssignedPartitionId = lastAssignedPartitionId;
        }

        public int lastAssignedPartitionId() {
            return this.lastAssignedPartitionId;
        }

        @Override
        public void validate(TableMetadata base) {
            if (base != null && base.lastAssignedPartitionId() != this.lastAssignedPartitionId) {
                throw new CommitFailedException("Requirement failed: last assigned partition id changed: expected id %s != %s", this.lastAssignedPartitionId, base.lastAssignedPartitionId());
            }
        }
    }

    public static class AssertCurrentSchemaID
    implements UpdateRequirement {
        private final int schemaId;

        public AssertCurrentSchemaID(int schemaId) {
            this.schemaId = schemaId;
        }

        public int schemaId() {
            return this.schemaId;
        }

        @Override
        public void validate(TableMetadata base) {
            if (this.schemaId != base.currentSchemaId()) {
                throw new CommitFailedException("Requirement failed: current schema changed: expected id %s != %s", this.schemaId, base.currentSchemaId());
            }
        }
    }

    public static class AssertLastAssignedFieldId
    implements UpdateRequirement {
        private final int lastAssignedFieldId;

        public AssertLastAssignedFieldId(int lastAssignedFieldId) {
            this.lastAssignedFieldId = lastAssignedFieldId;
        }

        public int lastAssignedFieldId() {
            return this.lastAssignedFieldId;
        }

        @Override
        public void validate(TableMetadata base) {
            if (base != null && base.lastColumnId() != this.lastAssignedFieldId) {
                throw new CommitFailedException("Requirement failed: last assigned field id changed: expected id %s != %s", this.lastAssignedFieldId, base.lastColumnId());
            }
        }
    }

    public static class AssertRefSnapshotID
    implements UpdateRequirement {
        private final String name;
        private final Long snapshotId;

        public AssertRefSnapshotID(String name, Long snapshotId) {
            this.name = name;
            this.snapshotId = snapshotId;
        }

        public String refName() {
            return this.name;
        }

        public Long snapshotId() {
            return this.snapshotId;
        }

        @Override
        public void validate(TableMetadata base) {
            SnapshotRef ref = base.ref(this.name);
            if (ref != null) {
                String type;
                String string = type = ref.isBranch() ? "branch" : "tag";
                if (this.snapshotId == null) {
                    throw new CommitFailedException("Requirement failed: %s %s was created concurrently", type, this.name);
                }
                if (this.snapshotId.longValue() != ref.snapshotId()) {
                    throw new CommitFailedException("Requirement failed: %s %s has changed: expected id %s != %s", type, this.name, this.snapshotId, ref.snapshotId());
                }
            } else if (this.snapshotId != null) {
                throw new CommitFailedException("Requirement failed: branch or tag %s is missing, expected %s", this.name, this.snapshotId);
            }
        }
    }

    public static class AssertViewUUID
    implements UpdateRequirement {
        private final String uuid;

        public AssertViewUUID(String uuid) {
            Preconditions.checkArgument(uuid != null, "Invalid required UUID: null");
            this.uuid = uuid;
        }

        public String uuid() {
            return this.uuid;
        }

        @Override
        public void validate(ViewMetadata base) {
            if (!this.uuid.equalsIgnoreCase(base.uuid())) {
                throw new CommitFailedException("Requirement failed: view UUID does not match: expected %s != %s", base.uuid(), this.uuid);
            }
        }
    }

    public static class AssertTableUUID
    implements UpdateRequirement {
        private final String uuid;

        public AssertTableUUID(String uuid) {
            Preconditions.checkArgument(uuid != null, "Invalid required UUID: null");
            this.uuid = uuid;
        }

        public String uuid() {
            return this.uuid;
        }

        @Override
        public void validate(TableMetadata base) {
            if (!this.uuid.equalsIgnoreCase(base.uuid())) {
                throw new CommitFailedException("Requirement failed: UUID does not match: expected %s != %s", base.uuid(), this.uuid);
            }
        }
    }

    public static class AssertTableDoesNotExist
    implements UpdateRequirement {
        @Override
        public void validate(TableMetadata base) {
            if (base != null) {
                throw new CommitFailedException("Requirement failed: table already exists", new Object[0]);
            }
        }
    }
}

