/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.ContentFileParser;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SingleValueParser;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.JsonUtil;

class DataTaskParser {
    private static final String SCHEMA = "schema";
    private static final String PROJECTED_SCHEMA = "projection";
    private static final String METADATA_FILE = "metadata-file";
    private static final String ROWS = "rows";

    private DataTaskParser() {
    }

    static void toJson(StaticDataTask dataTask, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(dataTask != null, "Invalid data task: null");
        Preconditions.checkArgument(generator != null, "Invalid JSON generator: null");
        generator.writeFieldName(SCHEMA);
        SchemaParser.toJson(dataTask.schema(), generator);
        generator.writeFieldName(PROJECTED_SCHEMA);
        SchemaParser.toJson(dataTask.projectedSchema(), generator);
        generator.writeFieldName(METADATA_FILE);
        ContentFileParser.toJson(dataTask.metadataFile(), PartitionSpec.unpartitioned(), generator);
        Preconditions.checkArgument(dataTask.tableRows() != null, "Invalid data task: null table rows");
        generator.writeArrayFieldStart(ROWS);
        for (StructLike row : dataTask.tableRows()) {
            SingleValueParser.toJson((Type)dataTask.schema().asStruct(), (Object)row, generator);
        }
        generator.writeEndArray();
    }

    static StaticDataTask fromJson(JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode != null, "Invalid JSON node for data task: null");
        Preconditions.checkArgument(jsonNode.isObject(), "Invalid JSON node for data task: non-object (%s)", (Object)jsonNode);
        Schema schema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, jsonNode));
        Schema projectedSchema = SchemaParser.fromJson(JsonUtil.get(PROJECTED_SCHEMA, jsonNode));
        DataFile metadataFile = (DataFile)ContentFileParser.fromJson(JsonUtil.get(METADATA_FILE, jsonNode), PartitionSpec.unpartitioned());
        JsonNode rowsArray = JsonUtil.get(ROWS, jsonNode);
        Preconditions.checkArgument(rowsArray.isArray(), "Invalid JSON node for rows: non-array (%s)", (Object)rowsArray);
        StructLike[] rows = new StructLike[rowsArray.size()];
        for (int i = 0; i < rowsArray.size(); ++i) {
            JsonNode rowNode = rowsArray.get(i);
            rows[i] = (StructLike)SingleValueParser.fromJson((Type)schema.asStruct(), rowNode);
        }
        return new StaticDataTask(metadataFile, schema, projectedSchema, rows);
    }
}

