/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.accumulo.predicate.compare.CompareOp;
import org.apache.hadoop.hive.accumulo.predicate.compare.DoubleCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.IntCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.LongCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.apache.hadoop.hive.accumulo.predicate.compare.StringCompare;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushdownTuple {
    private static final Logger log = LoggerFactory.getLogger(PushdownTuple.class);
    private byte[] constVal;
    private PrimitiveComparison pCompare;
    private CompareOp cOpt;

    public PushdownTuple(IndexSearchCondition sc, PrimitiveComparison pCompare, CompareOp cOpt) throws SerDeException {
        ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
        try {
            this.pCompare = pCompare;
            this.cOpt = cOpt;
            Writable writable = (Writable)eval.evaluate(null);
            this.constVal = this.getConstantAsBytes(writable);
        }
        catch (ClassCastException cce) {
            log.info(StringUtils.stringifyException((Throwable)cce));
            throw new SerDeException(" Column type mismatch in where clause " + sc.getIndexExpr().getExprString() + " found type " + sc.getConstantDesc().getTypeString() + " instead of " + sc.getColumnDesc().getTypeString());
        }
        catch (HiveException e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public byte[] getConstVal() {
        return this.constVal;
    }

    public PrimitiveComparison getpCompare() {
        return this.pCompare;
    }

    public CompareOp getcOpt() {
        return this.cOpt;
    }

    public byte[] getConstantAsBytes(Writable writable) throws SerDeException {
        if (this.pCompare instanceof StringCompare) {
            return writable.toString().getBytes();
        }
        if (this.pCompare instanceof DoubleCompare) {
            byte[] bts = new byte[8];
            double val = ((DoubleWritable)writable).get();
            ByteBuffer.wrap(bts).putDouble(val);
            return bts;
        }
        if (this.pCompare instanceof IntCompare) {
            byte[] bts = new byte[4];
            int val = ((IntWritable)writable).get();
            ByteBuffer.wrap(bts).putInt(val);
            return bts;
        }
        if (this.pCompare instanceof LongCompare) {
            byte[] bts = new byte[8];
            long val = ((LongWritable)writable).get();
            ByteBuffer.wrap(bts).putLong(val);
            return bts;
        }
        throw new SerDeException("Unsupported primitive category: " + this.pCompare.getClass().getName());
    }
}

