/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.ColumnMappingFactory;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMapper {
    private static final Logger log = LoggerFactory.getLogger(ColumnMapper.class);
    private List<ColumnMapping> columnMappings;
    private int rowIdOffset;
    private HiveAccumuloRowIdColumnMapping rowIdMapping = null;
    private final ColumnEncoding defaultEncoding;

    public ColumnMapper(String serializedColumnMappings, String defaultStorageType, List<String> columnNames, List<TypeInfo> columnTypes) throws TooManyAccumuloColumnsException {
        Preconditions.checkNotNull((Object)serializedColumnMappings);
        String[] parsedColumnMappingValue = StringUtils.split((String)serializedColumnMappings, (char)',');
        this.columnMappings = new ArrayList<ColumnMapping>(parsedColumnMappingValue.length);
        this.rowIdOffset = -1;
        this.defaultEncoding = null == defaultStorageType || "".equals(defaultStorageType) ? ColumnEncoding.getDefault() : ColumnEncoding.get(defaultStorageType.toLowerCase());
        if (parsedColumnMappingValue.length > columnNames.size()) {
            throw new TooManyAccumuloColumnsException("Found " + parsedColumnMappingValue.length + " columns, but only know of " + columnNames.size() + " Hive column names");
        }
        if (parsedColumnMappingValue.length > columnTypes.size()) {
            throw new TooManyAccumuloColumnsException("Found " + parsedColumnMappingValue.length + " columns, but only know of " + columnNames.size() + " Hive column types");
        }
        for (int i = 0; i < parsedColumnMappingValue.length; ++i) {
            String columnMappingStr = parsedColumnMappingValue[i];
            ColumnMapping columnMapping = ColumnMappingFactory.get(columnMappingStr, this.defaultEncoding, columnNames.get(i), columnTypes.get(i));
            if (columnMapping instanceof HiveAccumuloRowIdColumnMapping) {
                if (-1 != this.rowIdOffset) {
                    throw new IllegalArgumentException("Column mapping should only have one definition with a value of :rowID");
                }
                this.rowIdOffset = i;
                this.rowIdMapping = (HiveAccumuloRowIdColumnMapping)columnMapping;
            }
            this.columnMappings.add(columnMapping);
        }
    }

    public int size() {
        return this.columnMappings.size();
    }

    public ColumnMapping get(int i) {
        return this.columnMappings.get(i);
    }

    public List<ColumnMapping> getColumnMappings() {
        return Collections.unmodifiableList(this.columnMappings);
    }

    public boolean hasRowIdMapping() {
        return null != this.rowIdMapping;
    }

    public HiveAccumuloRowIdColumnMapping getRowIdMapping() {
        return this.rowIdMapping;
    }

    public int getRowIdOffset() {
        return this.rowIdOffset;
    }

    public String getTypesString() {
        StringBuilder sb = new StringBuilder();
        for (ColumnMapping columnMapping : this.columnMappings) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            if (columnMapping instanceof HiveAccumuloRowIdColumnMapping) {
                sb.append("string");
                continue;
            }
            if (columnMapping instanceof HiveAccumuloColumnMapping) {
                sb.append("string");
                continue;
            }
            if (columnMapping instanceof HiveAccumuloMapColumnMapping) {
                sb.append("map").append("<").append("string").append(",").append("string").append(">");
                continue;
            }
            throw new IllegalArgumentException("Cannot process ColumnMapping of type " + columnMapping.getClass().getName());
        }
        return sb.toString();
    }

    public ColumnMapping getColumnMappingForHiveColumn(List<String> hiveColumns, String hiveColumnName) {
        Preconditions.checkNotNull(hiveColumns);
        Preconditions.checkNotNull((Object)hiveColumnName);
        Preconditions.checkArgument((this.columnMappings.size() <= hiveColumns.size() ? 1 : 0) != 0, (Object)("Expected equal number of column mappings and Hive columns, " + String.valueOf(this.columnMappings) + ", " + String.valueOf(hiveColumns)));
        for (int hiveColumnOffset = 0; hiveColumnOffset < hiveColumns.size() && hiveColumnOffset < this.columnMappings.size(); ++hiveColumnOffset) {
            if (!hiveColumns.get(hiveColumnOffset).equals(hiveColumnName)) continue;
            return this.columnMappings.get(hiveColumnOffset);
        }
        log.error("Could not find offset for Hive column with name '" + hiveColumnName + "' with columns " + String.valueOf(hiveColumns));
        throw new IllegalArgumentException("Could not find offset for Hive column with name " + hiveColumnName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getClass().getSimpleName()).append(" ");
        sb.append(this.columnMappings).append(", rowIdOffset: ").append(this.rowIdOffset).append(", defaultEncoding: ");
        sb.append((Object)this.defaultEncoding).append("]");
        return sb.toString();
    }
}

