/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;

public abstract class DataType {
    public static final byte NULL = 1;
    public static final byte BOOLEAN = 5;
    public static final byte BYTE = 6;
    public static final byte INTEGER = 10;
    public static final byte SHORT = 11;
    public static final byte LONG = 15;
    public static final byte FLOAT = 20;
    public static final byte DOUBLE = 25;
    public static final byte STRING = 55;
    public static final byte BINARY = 60;
    public static final byte CHAR = 61;
    public static final byte VARCHAR = 62;
    public static final byte DECIMAL = 63;
    public static final byte DATE = 64;
    public static final byte TIMESTAMP = 65;
    public static final byte MAP = 100;
    public static final byte STRUCT = 110;
    public static final byte LIST = 120;
    public static final byte ERROR = -1;

    public static byte findType(Object o) {
        if (o == null) {
            return 1;
        }
        Class<?> clazz = o.getClass();
        if (clazz == String.class) {
            return 55;
        }
        if (clazz == Integer.class) {
            return 10;
        }
        if (clazz == Long.class) {
            return 15;
        }
        if (clazz == Float.class) {
            return 20;
        }
        if (clazz == Double.class) {
            return 25;
        }
        if (clazz == Boolean.class) {
            return 5;
        }
        if (clazz == Byte.class) {
            return 6;
        }
        if (clazz == Short.class) {
            return 11;
        }
        if (o instanceof List) {
            return 120;
        }
        if (o instanceof Map) {
            return 100;
        }
        if (o instanceof byte[]) {
            return 60;
        }
        if (o instanceof HiveChar) {
            return 61;
        }
        if (o instanceof HiveVarchar) {
            return 62;
        }
        if (o instanceof HiveDecimal) {
            return 63;
        }
        if (o instanceof Date) {
            return 64;
        }
        if (o instanceof Timestamp) {
            return 65;
        }
        return -1;
    }

    public static int compare(Object o1, Object o2) {
        return DataType.compare(o1, o2, DataType.findType(o1), DataType.findType(o2));
    }

    public static int compare(Object o1, Object o2, byte dt1, byte dt2) {
        if (dt1 == dt2) {
            switch (dt1) {
                case 1: {
                    return 0;
                }
                case 5: {
                    return ((Boolean)o1).compareTo((Boolean)o2);
                }
                case 6: {
                    return ((Byte)o1).compareTo((Byte)o2);
                }
                case 10: {
                    return ((Integer)o1).compareTo((Integer)o2);
                }
                case 15: {
                    return ((Long)o1).compareTo((Long)o2);
                }
                case 20: {
                    return ((Float)o1).compareTo((Float)o2);
                }
                case 25: {
                    return ((Double)o1).compareTo((Double)o2);
                }
                case 55: {
                    return ((String)o1).compareTo((String)o2);
                }
                case 11: {
                    return ((Short)o1).compareTo((Short)o2);
                }
                case 60: {
                    return DataType.compareByteArray((byte[])o1, (byte[])o2);
                }
                case 120: {
                    List l1 = (List)o1;
                    List l2 = (List)o2;
                    int len = l1.size();
                    if (len != l2.size()) {
                        return len - l2.size();
                    }
                    for (int i = 0; i < len; ++i) {
                        int cmpVal = DataType.compare(l1.get(i), l2.get(i));
                        if (cmpVal == 0) continue;
                        return cmpVal;
                    }
                    return 0;
                }
                case 100: {
                    Map m1 = (Map)o1;
                    Map m2 = (Map)o2;
                    int sz1 = m1.size();
                    int sz2 = m2.size();
                    if (sz1 < sz2) {
                        return -1;
                    }
                    if (sz1 > sz2) {
                        return 1;
                    }
                    TreeMap tm1 = new TreeMap(m1);
                    TreeMap tm2 = new TreeMap(m2);
                    Iterator i1 = tm1.entrySet().iterator();
                    Iterator i2 = tm2.entrySet().iterator();
                    while (i1.hasNext()) {
                        Map.Entry entry1 = i1.next();
                        Map.Entry entry2 = i2.next();
                        int c = DataType.compare(entry1.getValue(), entry2.getValue());
                        if (c != 0) {
                            return c;
                        }
                        c = DataType.compare(entry1.getValue(), entry2.getValue());
                        if (c == 0) continue;
                        return c;
                    }
                    return 0;
                }
                case 61: {
                    return ((HiveChar)o1).compareTo((HiveChar)o2);
                }
                case 62: {
                    return ((HiveVarchar)o1).compareTo((HiveVarchar)o2);
                }
                case 63: {
                    return ((HiveDecimal)o1).compareTo((HiveDecimal)o2);
                }
                case 64: {
                    return ((Date)o1).compareTo((Date)o2);
                }
                case 65: {
                    return ((Timestamp)o1).compareTo((Timestamp)o2);
                }
            }
            throw new RuntimeException("Unkown type " + dt1 + " in compare");
        }
        return dt1 < dt2 ? -1 : 1;
    }

    private static int compareByteArray(byte[] o1, byte[] o2) {
        for (int i = 0; i < o1.length; ++i) {
            if (i == o2.length) {
                return 1;
            }
            if (o1[i] == o2[i]) continue;
            if (o1[i] > o2[i]) {
                return 1;
            }
            return -1;
        }
        if (o2.length > o1.length) {
            return -1;
        }
        return 0;
    }
}

