/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.io;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import org.apache.hadoop.hive.common.io.FetchConverter;

public class DigestPrintStream
extends FetchConverter {
    private final MessageDigest digest = MessageDigest.getInstance("MD5");

    public DigestPrintStream(OutputStream out, String encoding) throws Exception {
        super(out, false, encoding);
    }

    @Override
    protected void process(String out) {
        this.digest.update(out.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void processFinal() {
        this.printDirect(Base64.getEncoder().encodeToString(this.digest.digest()));
        this.digest.reset();
    }
}

