/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import java.io.PrintStream;
import org.apache.orc.TypeDescription;

abstract class HiveType {
    protected Kind kind;

    HiveType(Kind kind) {
        this.kind = kind;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return ((HiveType)other).kind.equals((Object)this.kind);
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public abstract boolean subsumes(HiveType var1);

    public abstract void merge(HiveType var1);

    public void printFlat(PrintStream out, String prefix) {
        out.println(prefix + ": " + String.valueOf(this));
    }

    public abstract TypeDescription getSchema();

    static enum Kind {
        NULL(0),
        BOOLEAN(1),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        DECIMAL(5),
        FLOAT(6),
        DOUBLE(7),
        BINARY(1),
        DATE(1),
        TIMESTAMP(1),
        TIMESTAMP_INSTANT(1),
        STRING(2),
        STRUCT(1, false),
        LIST(1, false),
        UNION(8, false),
        MAP(9, false);

        final int rank;
        final boolean isPrimitive;

        private Kind(int rank, boolean isPrimitive) {
            this.rank = rank;
            this.isPrimitive = isPrimitive;
        }

        private Kind(int rank) {
            this(rank, true);
        }
    }
}

