/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.hadoop.io.WritableUtils;

@Deprecated
public class NumSummation
implements Aggregator {
    long sum = 0L;

    @Override
    public Value aggregate() {
        try {
            return new Value(NumSummation.longToBytes(this.sum));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void collect(Value value) {
        long l;
        try {
            l = NumSummation.bytesToLong(value.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.sum = NumSummation.safeAdd(this.sum, l);
    }

    public static byte[] longToBytes(long l) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        WritableUtils.writeVLong((DataOutput)dos, (long)l);
        return baos.toByteArray();
    }

    public static long bytesToLong(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        return WritableUtils.readVLong((DataInput)dis);
    }

    public static long safeAdd(long a, long b) {
        long aSign = Long.signum(a);
        long bSign = Long.signum(b);
        if (aSign != 0L && bSign != 0L && aSign == bSign) {
            if (aSign > 0L) {
                if (Long.MAX_VALUE - a < b) {
                    return Long.MAX_VALUE;
                }
            } else if (Long.MIN_VALUE - a > b) {
                return Long.MIN_VALUE;
            }
        }
        return a + b;
    }

    @Override
    public void reset() {
        this.sum = 0L;
    }
}

