/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.DelegationTokenConfigSerializer;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TDelegationToken;
import org.apache.accumulo.core.security.thrift.TDelegationTokenConfig;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.ByteBufferUtil;

public class SecurityOperationsImpl
implements SecurityOperations {
    private final ClientContext context;

    private void executeVoid(ClientExec<ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            ServerClient.executeRawVoid(this.context, exec);
        }
        catch (ThriftTableOperationException ttoe) {
            if (ttoe.getType() == TableOperationExceptionType.NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (ttoe.getType() == TableOperationExceptionType.NAMESPACE_NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
            }
            throw new AccumuloException((Throwable)((Object)ttoe));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    private <T> T execute(ClientExecReturn<T, ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return ServerClient.executeRaw(this.context, exec);
        }
        catch (ThriftTableOperationException ttoe) {
            if (ttoe.getType() == TableOperationExceptionType.NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (ttoe.getType() == TableOperationExceptionType.NAMESPACE_NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
            }
            throw new AccumuloException((Throwable)((Object)ttoe));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public SecurityOperationsImpl(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
    }

    @Override
    @Deprecated
    public void createUser(String user, byte[] password, Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        this.createLocalUser(user, new PasswordToken(password));
        this.changeUserAuthorizations(user, authorizations);
    }

    @Override
    public void createLocalUser(final String principal, final PasswordToken password) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        if (null == this.context.getSaslParams()) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password is null");
        }
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                if (null == SecurityOperationsImpl.this.context.getSaslParams()) {
                    client.createLocalUser(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, ByteBuffer.wrap(password.getPassword()));
                } else {
                    client.createLocalUser(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, ByteBuffer.wrap(new byte[0]));
                }
            }
        });
    }

    @Override
    @Deprecated
    public void dropUser(String user) throws AccumuloException, AccumuloSecurityException {
        this.dropLocalUser(user);
    }

    @Override
    public void dropLocalUser(final String principal) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.dropLocalUser(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal);
            }
        });
    }

    @Override
    @Deprecated
    public boolean authenticateUser(String user, byte[] password) throws AccumuloException, AccumuloSecurityException {
        return this.authenticateUser(user, new PasswordToken(password));
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        final Credentials toAuth = new Credentials(principal, token);
        return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.authenticateUser(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), toAuth.toThrift(SecurityOperationsImpl.this.context.getInstance()));
            }
        });
    }

    @Override
    @Deprecated
    public void changeUserPassword(String user, byte[] password) throws AccumuloException, AccumuloSecurityException {
        this.changeLocalUserPassword(user, new PasswordToken(password));
    }

    @Override
    public void changeLocalUserPassword(final String principal, final PasswordToken token) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        Credentials toChange = new Credentials(principal, token);
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.changeLocalUserPassword(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, ByteBuffer.wrap(token.getPassword()));
            }
        });
        if (this.context.getCredentials().getPrincipal().equals(principal)) {
            this.context.setCredentials(toChange);
        }
    }

    @Override
    public void changeUserAuthorizations(final String principal, final Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.changeAuthorizations(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, ByteBufferUtil.toByteBuffers(authorizations.getAuthorizations()));
            }
        });
    }

    @Override
    public Authorizations getUserAuthorizations(final String principal) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        return this.execute(new ClientExecReturn<Authorizations, ClientService.Client>(){

            @Override
            public Authorizations execute(ClientService.Client client) throws Exception {
                return new Authorizations(client.getUserAuthorizations(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal));
            }
        });
    }

    @Override
    public boolean hasSystemPermission(final String principal, final SystemPermission perm) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((perm != null ? 1 : 0) != 0, (Object)"perm is null");
        return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.hasSystemPermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, perm.getId());
            }
        });
    }

    @Override
    public boolean hasTablePermission(final String principal, final String table, final TablePermission perm) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((perm != null ? 1 : 0) != 0, (Object)"perm is null");
        try {
            return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

                @Override
                public Boolean execute(ClientService.Client client) throws Exception {
                    return client.hasTablePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, table, perm.getId());
                }
            });
        }
        catch (AccumuloSecurityException e) {
            if (e.getSecurityErrorCode() == org.apache.accumulo.core.client.security.SecurityErrorCode.NAMESPACE_DOESNT_EXIST) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST, e);
            }
            throw e;
        }
    }

    @Override
    public boolean hasNamespacePermission(final String principal, final String namespace, final NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.hasNamespacePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, namespace, permission.getId());
            }
        });
    }

    @Override
    public void grantSystemPermission(final String principal, final SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.grantSystemPermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, permission.getId());
            }
        });
    }

    @Override
    public void grantTablePermission(final String principal, final String table, final TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        try {
            this.executeVoid(new ClientExec<ClientService.Client>(){

                @Override
                public void execute(ClientService.Client client) throws Exception {
                    client.grantTablePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, table, permission.getId());
                }
            });
        }
        catch (AccumuloSecurityException e) {
            if (e.getSecurityErrorCode() == org.apache.accumulo.core.client.security.SecurityErrorCode.NAMESPACE_DOESNT_EXIST) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST, e);
            }
            throw e;
        }
    }

    @Override
    public void grantNamespacePermission(final String principal, final String namespace, final NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.grantNamespacePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, namespace, permission.getId());
            }
        });
    }

    @Override
    public void revokeSystemPermission(final String principal, final SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.revokeSystemPermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, permission.getId());
            }
        });
    }

    @Override
    public void revokeTablePermission(final String principal, final String table, final TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        try {
            this.executeVoid(new ClientExec<ClientService.Client>(){

                @Override
                public void execute(ClientService.Client client) throws Exception {
                    client.revokeTablePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, table, permission.getId());
                }
            });
        }
        catch (AccumuloSecurityException e) {
            if (e.getSecurityErrorCode() == org.apache.accumulo.core.client.security.SecurityErrorCode.NAMESPACE_DOESNT_EXIST) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST, e);
            }
            throw e;
        }
    }

    @Override
    public void revokeNamespacePermission(final String principal, final String namespace, final NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((permission != null ? 1 : 0) != 0, (Object)"permission is null");
        this.executeVoid(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.revokeNamespacePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), principal, namespace, permission.getId());
            }
        });
    }

    @Override
    @Deprecated
    public Set<String> listUsers() throws AccumuloException, AccumuloSecurityException {
        return this.listLocalUsers();
    }

    @Override
    public Set<String> listLocalUsers() throws AccumuloException, AccumuloSecurityException {
        return this.execute(new ClientExecReturn<Set<String>, ClientService.Client>(){

            @Override
            public Set<String> execute(ClientService.Client client) throws Exception {
                return client.listLocalUsers(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds());
            }
        });
    }

    @Override
    public DelegationToken getDelegationToken(DelegationTokenConfig cfg) throws AccumuloException, AccumuloSecurityException {
        TDelegationToken thriftToken;
        final TDelegationTokenConfig tConfig = null != cfg ? DelegationTokenConfigSerializer.serialize(cfg) : new TDelegationTokenConfig();
        try {
            thriftToken = MasterClient.execute(this.context, new ClientExecReturn<TDelegationToken, MasterClientService.Client>(){

                @Override
                public TDelegationToken execute(MasterClientService.Client client) throws Exception {
                    return client.getDelegationToken(Tracer.traceInfo(), SecurityOperationsImpl.this.context.rpcCreds(), tConfig);
                }
            });
        }
        catch (TableNotFoundException e) {
            throw new AssertionError("Received TableNotFoundException on method which should not throw that exception", e);
        }
        AuthenticationTokenIdentifier identifier = new AuthenticationTokenIdentifier(thriftToken.getIdentifier());
        return new DelegationTokenImpl(thriftToken.getPassword(), identifier);
    }
}

