/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class SchemaRule
implements Rule<JClassContainer, JType> {
    private final RuleFactory ruleFactory;

    protected SchemaRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode schemaNode, JsonNode parent, JClassContainer generatableType, Schema schema) {
        if (schemaNode.has("$ref")) {
            String nameFromRef = this.nameFromRef(schemaNode.get("$ref").asText());
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText(), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            schemaNode = schema.getContent();
            if (schema.isGenerated()) {
                return schema.getJavaType();
            }
            return this.apply(nameFromRef != null ? nameFromRef : nodeName, schemaNode, parent, generatableType, schema);
        }
        schema = schema.deriveChildSchema(schemaNode);
        JType javaType = schemaNode.has("enum") ? this.ruleFactory.getEnumRule().apply(nodeName, schemaNode, parent, generatableType, schema) : this.ruleFactory.getTypeRule().apply(nodeName, schemaNode, parent, generatableType.getPackage(), schema);
        schema.setJavaTypeIfEmpty(javaType);
        return javaType;
    }

    private String nameFromRef(String ref) {
        String nameFromRef;
        if ("#".equals(ref)) {
            return null;
        }
        if (!StringUtils.contains((CharSequence)ref, "#")) {
            nameFromRef = Jsonschema2Pojo.getNodeName(ref, this.ruleFactory.getGenerationConfig());
        } else {
            String[] nameParts = StringUtils.split(ref, "/\\#");
            nameFromRef = nameParts[nameParts.length - 1];
        }
        try {
            return URLDecoder.decode(nameFromRef, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GenerationException("Failed to decode ref: " + ref, e);
        }
    }
}

