/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.server.KillQueryZookeeperManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillQueryImpl
implements KillQuery {
    private static final Logger LOG = LoggerFactory.getLogger(KillQueryImpl.class);
    private final OperationManager operationManager;
    private final KillQueryZookeeperManager killQueryZookeeperManager;

    public KillQueryImpl(OperationManager operationManager, KillQueryZookeeperManager killQueryZookeeperManager) {
        this.operationManager = operationManager;
        this.killQueryZookeeperManager = killQueryZookeeperManager;
    }

    public static Set<ApplicationId> getChildYarnJobs(Configuration conf, String tag, String doAs, boolean doAsAdmin) throws IOException, YarnException {
        HashSet<ApplicationId> childYarnJobs = new HashSet<ApplicationId>();
        GetApplicationsRequest gar = GetApplicationsRequest.newInstance();
        gar.setScope(ApplicationsRequestScope.OWN);
        gar.setApplicationTags(Collections.singleton(tag));
        ApplicationClientProtocol proxy = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class);
        GetApplicationsResponse apps = proxy.getApplications(gar);
        List appsList = apps.getApplicationList();
        for (ApplicationReport appReport : appsList) {
            if (doAsAdmin) {
                childYarnJobs.add(appReport.getApplicationId());
                continue;
            }
            if (!StringUtils.isNotBlank(doAs) || !appReport.getApplicationTags().contains("userid=" + doAs)) continue;
            childYarnJobs.add(appReport.getApplicationId());
        }
        if (childYarnJobs.isEmpty()) {
            LOG.info("No child applications found");
        } else {
            LOG.info("Found child YARN applications: " + StringUtils.join(childYarnJobs, ","));
        }
        return childYarnJobs;
    }

    public static void killChildYarnJobs(Configuration conf, String tag, String doAs, boolean doAsAdmin) {
        try {
            if (tag == null) {
                return;
            }
            LOG.info("Killing yarn jobs using query tag:" + tag);
            Set<ApplicationId> childYarnJobs = KillQueryImpl.getChildYarnJobs(conf, tag, doAs, doAsAdmin);
            if (!childYarnJobs.isEmpty()) {
                YarnClient yarnClient = YarnClient.createYarnClient();
                yarnClient.init(conf);
                yarnClient.start();
                for (ApplicationId app : childYarnJobs) {
                    yarnClient.killApplication(app);
                }
            }
        }
        catch (IOException | YarnException ye) {
            LOG.warn("Exception occurred while killing child job({})", (Object)tag, (Object)ye);
        }
    }

    private static boolean isAdmin() {
        boolean isAdmin = false;
        HivePrivilegeObject serviceNameObj = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.SERVICE_NAME, "hiveservice");
        SessionState ss = SessionState.get();
        if (!HiveConf.getBoolVar(ss.getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            try {
                return StringUtils.equals(ss.getUserName(), UserGroupInformation.getCurrentUser().getShortUserName());
            }
            catch (IOException e) {
                LOG.warn("Unable to check for admin privileges", e);
                return false;
            }
        }
        if (ss.getAuthorizerV2() != null) {
            try {
                ss.getAuthorizerV2().checkPrivileges(HiveOperationType.KILL_QUERY, Arrays.asList(serviceNameObj), new ArrayList(), new HiveAuthzContext.Builder().build());
                isAdmin = true;
            }
            catch (Exception e) {
                LOG.warn("Error while checking privileges", e);
            }
        }
        return isAdmin;
    }

    private boolean cancelOperation(Operation operation, String doAs, boolean doAsAdmin, String errMsg) throws HiveSQLException {
        if (doAsAdmin || !StringUtils.isBlank(doAs) && operation.getParentSession().getUserName().equals(doAs)) {
            OperationHandle handle = operation.getHandle();
            this.operationManager.cancelOperation(handle, errMsg);
            return true;
        }
        return false;
    }

    public boolean isLocalQuery(String queryIdOrTag) {
        TagOrId tagOrId = TagOrId.UNKNOWN;
        if (this.operationManager.getOperationByQueryId(queryIdOrTag) != null) {
            tagOrId = TagOrId.ID;
        } else if (!this.operationManager.getOperationsByQueryTag(queryIdOrTag).isEmpty()) {
            tagOrId = TagOrId.TAG;
        }
        return tagOrId != TagOrId.UNKNOWN;
    }

    public void killQuery(String queryIdOrTag, String errMsg, HiveConf conf) throws HiveException {
        this.killQuery(queryIdOrTag, errMsg, conf, false, SessionState.get().getUserName(), KillQueryImpl.isAdmin());
    }

    public void killLocalQuery(String queryIdOrTag, HiveConf conf, String doAs, boolean doAsAdmin) throws HiveException {
        this.killQuery(queryIdOrTag, null, conf, true, doAs, doAsAdmin);
    }

    private void killQuery(String queryIdOrTag, String errMsg, HiveConf conf, boolean onlyLocal, String doAs, boolean doAsAdmin) throws HiveException {
        errMsg = StringUtils.defaultString(errMsg, "User invoked KILL QUERY");
        TagOrId tagOrId = TagOrId.UNKNOWN;
        HashSet<Operation> operationsToKill = new HashSet<Operation>();
        if (this.operationManager.getOperationByQueryId(queryIdOrTag) != null) {
            operationsToKill.add(this.operationManager.getOperationByQueryId(queryIdOrTag));
            tagOrId = TagOrId.ID;
            LOG.debug("Query found with id: {}", (Object)queryIdOrTag);
        } else {
            operationsToKill.addAll(this.operationManager.getOperationsByQueryTag(queryIdOrTag));
            if (!operationsToKill.isEmpty()) {
                tagOrId = TagOrId.TAG;
                LOG.debug("Query found with tag: {}", (Object)queryIdOrTag);
            }
        }
        if (!operationsToKill.isEmpty()) {
            this.killOperations(queryIdOrTag, errMsg, conf, tagOrId, operationsToKill, doAs, doAsAdmin);
        } else {
            LOG.debug("Query not found with tag/id: {}", (Object)queryIdOrTag);
            if (!onlyLocal && this.killQueryZookeeperManager != null && conf.getBoolVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_KILLQUERY_ENABLE)) {
                try {
                    LOG.debug("Killing query with zookeeper coordination: " + queryIdOrTag);
                    this.killQueryZookeeperManager.killQuery(queryIdOrTag, SessionState.get().getAuthenticator().getUserName(), KillQueryImpl.isAdmin());
                }
                catch (IOException e) {
                    LOG.error("Kill query failed for queryId: " + queryIdOrTag, e);
                    throw new HiveException("Unable to kill query locally or on remote servers.", e);
                }
            } else {
                LOG.warn("Unable to kill query with id {}", (Object)queryIdOrTag);
            }
        }
    }

    private void killOperations(String queryIdOrTag, String errMsg, HiveConf conf, TagOrId tagOrId, Set<Operation> operationsToKill, String doAs, boolean doAsAdmin) throws HiveException {
        try {
            switch (tagOrId.ordinal()) {
                case 1: {
                    Operation operation = operationsToKill.iterator().next();
                    boolean canceled = this.cancelOperation(operation, doAs, doAsAdmin, errMsg);
                    if (canceled) {
                        String queryTag = operation.getQueryTag();
                        if (queryTag == null) {
                            queryTag = queryIdOrTag;
                        }
                        KillQueryImpl.killChildYarnJobs(conf, queryTag, doAs, doAsAdmin);
                        break;
                    }
                    throw new HiveSQLException("No privilege to kill query id");
                }
                case 0: {
                    int numCanceled = 0;
                    for (Operation operationToKill : operationsToKill) {
                        if (!this.cancelOperation(operationToKill, doAs, doAsAdmin, errMsg)) continue;
                        ++numCanceled;
                    }
                    if (numCanceled == 0) {
                        throw new HiveSQLException("No privilege to kill query tag");
                    }
                    KillQueryImpl.killChildYarnJobs(conf, queryIdOrTag, doAs, doAsAdmin);
                    break;
                }
            }
        }
        catch (HiveSQLException e) {
            LOG.error("Kill query failed for query " + queryIdOrTag, e);
            throw new HiveException(e.getMessage(), e);
        }
    }

    private static enum TagOrId {
        TAG,
        ID,
        UNKNOWN;

    }
}

