/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.ServiceRegistry;
import org.apache.hadoop.hive.registry.ServiceInstanceSet;
import org.apache.hadoop.hive.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.hive.registry.impl.ZkRegistryBase;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.hive.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.hive.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.hive.org.apache.curator.utils.CloseableUtils;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.AuthType;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hive.service.server.HiveServer2HAInstanceSet;
import org.apache.hive.service.server.HiveServer2Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HS2ActivePassiveHARegistry
extends ZkRegistryBase<HiveServer2Instance>
implements ServiceRegistry<HiveServer2Instance>,
HiveServer2HAInstanceSet,
HiveServer2.FailoverHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HS2ActivePassiveHARegistry.class);
    static final String ACTIVE_ENDPOINT = "activeEndpoint";
    static final String PASSIVE_ENDPOINT = "passiveEndpoint";
    private static final String SASL_LOGIN_CONTEXT_NAME = "HS2ActivePassiveHAZooKeeperClient";
    private static final String INSTANCE_PREFIX = "instance-";
    private static final String INSTANCE_GROUP = "instances";
    private static final String LEADER_LATCH_PATH = "/_LEADER";
    private LeaderLatch leaderLatch;
    private Map<LeaderLatchListener, ExecutorService> registeredListeners = new HashMap<LeaderLatchListener, ExecutorService>();
    private String latchPath;
    private ServiceRecord srv;
    private boolean isClient;
    private final String uniqueId;

    static HS2ActivePassiveHARegistry create(Configuration conf, boolean isClient) {
        String zkNameSpace = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_ACTIVE_PASSIVE_HA_REGISTRY_NAMESPACE);
        Preconditions.checkArgument(!StringUtils.isBlank(zkNameSpace), HiveConf.ConfVars.HIVE_SERVER2_ACTIVE_PASSIVE_HA_REGISTRY_NAMESPACE.varname + " cannot be null or empty");
        String principal = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keytab = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        String zkNameSpacePrefix = zkNameSpace + "-";
        return new HS2ActivePassiveHARegistry(null, zkNameSpacePrefix, LEADER_LATCH_PATH, principal, keytab, isClient ? SASL_LOGIN_CONTEXT_NAME : null, conf, isClient);
    }

    private HS2ActivePassiveHARegistry(String instanceName, String zkNamespacePrefix, String leaderLatchPath, String krbPrincipal, String krbKeytab, String saslContextName, Configuration conf, boolean isClient) {
        super(instanceName, conf, null, zkNamespacePrefix, null, INSTANCE_PREFIX, INSTANCE_GROUP, saslContextName, krbPrincipal, krbKeytab, null);
        this.isClient = isClient;
        this.uniqueId = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_IN_TEST) && conf.get("registry.unique.id") != null ? conf.get("registry.unique.id") : UNIQUE_ID.toString();
        this.latchPath = leaderLatchPath;
        this.leaderLatch = this.getNewLeaderLatchPath();
    }

    @Override
    public void start() throws IOException {
        super.start();
        if (!this.isClient) {
            this.srv = this.getNewServiceRecord();
            this.register();
            this.registerLeaderLatchListener(new HS2LeaderLatchListener(), null);
            try {
                this.leaderLatch.start();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            LOG.info("Registered HS2 with ZK. service record: {}", (Object)this.srv);
        } else {
            this.populateCache();
            LOG.info("Populating instances cache for client");
        }
    }

    @Override
    protected void unregisterInternal() {
        super.unregisterInternal();
    }

    @Override
    public String register() throws IOException {
        this.updateEndpoint(this.srv, PASSIVE_ENDPOINT);
        return this.registerServiceRecord(this.srv, this.uniqueId);
    }

    @Override
    public void unregister() {
        CloseableUtils.closeQuietly(this.leaderLatch);
        this.unregisterInternal();
    }

    @Override
    public void updateRegistration(Iterable<Map.Entry<String, String>> attributes) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void populateCache() throws IOException {
        PathChildrenCache pcc = this.ensureInstancesCache(0L);
        this.populateCache(pcc, false);
    }

    @Override
    public ServiceInstanceSet<HiveServer2Instance> getInstances(String component, long clusterReadyTimeoutMs) throws IOException {
        throw new IOException("Not supported to get instances by component name");
    }

    private void addActiveEndpointToServiceRecord() throws IOException {
        this.addEndpointToServiceRecord(this.getNewServiceRecord(), ACTIVE_ENDPOINT);
    }

    private void addPassiveEndpointToServiceRecord() throws IOException {
        this.addEndpointToServiceRecord(this.getNewServiceRecord(), PASSIVE_ENDPOINT);
    }

    private void addEndpointToServiceRecord(ServiceRecord srv, String endpointName) throws IOException {
        this.updateEndpoint(srv, endpointName);
        this.updateServiceRecord(srv, this.doCheckAcls, true);
    }

    private void updateEndpoint(ServiceRecord srv, String endpointName) {
        String instanceUri = srv.get("hive.server2.instance.uri");
        IPStackUtils.HostPort hostPort = IPStackUtils.getHostAndPort(instanceUri);
        String hostname = hostPort.getHostname();
        int port = hostPort.getPort();
        Endpoint urlEndpoint = RegistryTypeUtils.ipcEndpoint(endpointName, new InetSocketAddress(hostname, port));
        srv.addInternalEndpoint(urlEndpoint);
        LOG.info("Added {} endpoint to service record", (Object)urlEndpoint);
    }

    @Override
    public void stop() {
        CloseableUtils.closeQuietly(this.leaderLatch);
        super.stop();
    }

    @Override
    protected HiveServer2Instance createServiceInstance(ServiceRecord srv) throws IOException {
        Endpoint activeEndpoint = srv.getInternalEndpoint(ACTIVE_ENDPOINT);
        return new HiveServer2Instance(srv, activeEndpoint != null ? ACTIVE_ENDPOINT : PASSIVE_ENDPOINT);
    }

    @Override
    public synchronized void registerStateChangeListener(ServiceInstanceStateChangeListener<HiveServer2Instance> listener) throws IOException {
        super.registerStateChangeListener(listener);
    }

    @Override
    public ApplicationId getApplicationId() throws IOException {
        throw new IOException("Not supported until HS2 runs as YARN application");
    }

    @Override
    protected String getZkPathUser(Configuration conf) {
        return this.currentUser();
    }

    private boolean hasLeadership() {
        return this.leaderLatch.hasLeadership();
    }

    @Override
    public void failover() throws Exception {
        if (this.hasLeadership()) {
            LOG.info("Failover request received for HS2 instance: {}. Restarting leader latch..", (Object)this.uniqueId);
            this.leaderLatch.close(LeaderLatch.CloseMode.NOTIFY_LEADER);
            this.leaderLatch = this.getNewLeaderLatchPath();
            for (Map.Entry<LeaderLatchListener, ExecutorService> registeredListener : this.registeredListeners.entrySet()) {
                if (registeredListener.getValue() == null) {
                    this.leaderLatch.addListener(registeredListener.getKey());
                    continue;
                }
                this.leaderLatch.addListener(registeredListener.getKey(), registeredListener.getValue());
            }
            this.leaderLatch.start();
            LOG.info("Failover complete. Leader latch restarted successfully. New leader: {}", (Object)this.leaderLatch.getLeader().getId());
        } else {
            LOG.warn("Failover request received for HS2 instance: {} that is not leader. Skipping..", (Object)this.uniqueId);
        }
    }

    private LeaderLatch getNewLeaderLatchPath() {
        return new LeaderLatch(this.zooKeeperClient, this.latchPath, this.uniqueId, LeaderLatch.CloseMode.NOTIFY_LEADER);
    }

    @Override
    public HiveServer2Instance getLeader() {
        for (HiveServer2Instance hs2Instance : this.getAll()) {
            if (!hs2Instance.isLeader()) continue;
            return hs2Instance;
        }
        return null;
    }

    @Override
    public Collection<HiveServer2Instance> getAll() {
        return this.getAllInternal();
    }

    @Override
    public HiveServer2Instance getInstance(String instanceId) {
        for (HiveServer2Instance hs2Instance : this.getAll()) {
            if (!hs2Instance.getWorkerIdentity().equals(instanceId)) continue;
            return hs2Instance;
        }
        return null;
    }

    @Override
    public Set<HiveServer2Instance> getByHost(String host) {
        return this.getByHostInternal(host);
    }

    @Override
    public int size() {
        return this.sizeInternal();
    }

    void registerLeaderLatchListener(LeaderLatchListener latchListener, ExecutorService executorService) {
        this.registeredListeners.put(latchListener, executorService);
        if (executorService == null) {
            this.leaderLatch.addListener(latchListener);
        } else {
            this.leaderLatch.addListener(latchListener, executorService);
        }
    }

    private Map<String, String> getConfsToPublish() {
        HashMap<String, String> confsToPublish = new HashMap<String, String>();
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname));
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname));
        confsToPublish.put("hive.server2.instance.uri", this.conf.get("hive.server2.instance.uri"));
        confsToPublish.put("registry.unique.id", this.uniqueId);
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname));
        if (HiveServer2.isHttpTransportMode(new HiveConf(this.conf, Configuration.class))) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname));
        } else {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP.varname));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION.varname));
        if (AuthType.isKerberosAuthMode(this.conf)) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL.varname));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL.varname, this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL.varname));
        return confsToPublish;
    }

    private ServiceRecord getNewServiceRecord() {
        ServiceRecord srv = new ServiceRecord();
        Map<String, String> confsToPublish = this.getConfsToPublish();
        for (Map.Entry<String, String> entry : confsToPublish.entrySet()) {
            srv.set(entry.getKey(), entry.getValue());
        }
        return srv;
    }

    private class HS2LeaderLatchListener
    implements LeaderLatchListener {
        private HS2LeaderLatchListener() {
        }

        @Override
        public void isLeader() {
            try {
                if (!HS2ActivePassiveHARegistry.this.hasLeadership()) {
                    LOG.info("isLeader notification received but hasLeadership returned false.. awaiting..");
                    HS2ActivePassiveHARegistry.this.leaderLatch.await();
                }
                HS2ActivePassiveHARegistry.this.addActiveEndpointToServiceRecord();
                LOG.info("HS2 instance in ACTIVE mode. Service record: {}", (Object)HS2ActivePassiveHARegistry.this.srv);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to add active endpoint to service record", e);
            }
        }

        @Override
        public void notLeader() {
            try {
                if (HS2ActivePassiveHARegistry.this.hasLeadership()) {
                    LOG.info("notLeader notification received but hasLeadership returned true.. awaiting..");
                    HS2ActivePassiveHARegistry.this.leaderLatch.await();
                }
                HS2ActivePassiveHARegistry.this.addPassiveEndpointToServiceRecord();
                LOG.info("HS2 instance lost leadership. Switched to PASSIVE standby mode. Service record: {}", (Object)HS2ActivePassiveHARegistry.this.srv);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to add passive endpoint to service record", e);
            }
        }
    }
}

