/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.List;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.com.google.common.base.Strings;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupSearchFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(HiveConf conf) {
        String userSearchFilter = conf.get(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERSEARCHFILTER.varname);
        String userSearchBaseDN = conf.get(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN.varname);
        String groupSearchFilter = conf.get(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPSEARCHFILTER.varname);
        String groupSearchBaseDN = conf.get(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPBASEDN.varname);
        if (Strings.isNullOrEmpty(userSearchFilter) && Strings.isNullOrEmpty(groupSearchFilter) && Strings.isNullOrEmpty(groupSearchBaseDN)) {
            return null;
        }
        return new UserGroupSearchFilter(userSearchFilter, userSearchBaseDN, groupSearchFilter, groupSearchBaseDN);
    }

    private static final class UserGroupSearchFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(UserGroupSearchFilter.class);
        private final String userSearchFilter;
        private final String userBaseDN;
        private final String groupSearchFilter;
        private final String groupBaseDN;

        UserGroupSearchFilter(String userSearchFilter, String userBaseDN, String groupSearchFilter, String groupBaseDN) {
            this.userSearchFilter = userSearchFilter;
            this.userBaseDN = userBaseDN;
            this.groupSearchFilter = groupSearchFilter;
            this.groupBaseDN = groupBaseDN;
        }

        @Override
        public void apply(DirSearch client, String user) throws AuthenticationException {
            String userDn = null;
            try {
                List<String> resultList;
                if (!Strings.isNullOrEmpty(this.userSearchFilter) && !Strings.isNullOrEmpty(this.userBaseDN) && (userDn = client.findUserDn(user, this.userSearchFilter, this.userBaseDN)) == null) {
                    throw new AuthenticationException("Authentication failed: User search found no matching user");
                }
                if (!Strings.isNullOrEmpty(this.groupSearchFilter) && !Strings.isNullOrEmpty(this.groupBaseDN) ? (resultList = client.executeUserAndGroupFilterQuery(user, userDn, this.groupSearchFilter, this.groupBaseDN)) != null && resultList.size() > 0 : userDn != null) {
                    return;
                }
                throw new AuthenticationException("Authentication failed: User search does not satisfy filter condition");
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
        }
    }
}

