/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.curator.framework.listen;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hive.org.apache.curator.framework.listen.ListenerEntry;
import org.apache.hive.org.apache.curator.framework.listen.ListenerManager;
import org.apache.hive.org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingListenerManager<K, V>
implements ListenerManager<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<K, ListenerEntry<V>> listeners = new ConcurrentHashMap<K, ListenerEntry<V>>();
    private final Function<K, V> mapper;

    public static <K, V> ListenerManager<K, V> mapping(Function<K, V> mapper) {
        return new MappingListenerManager<K, V>(mapper);
    }

    @Override
    public void addListener(K listener) {
        this.addListener(listener, Runnable::run);
    }

    @Override
    public void addListener(K listener, Executor executor) {
        V mapped = this.mapper.apply(listener);
        this.listeners.put(listener, new ListenerEntry<V>(mapped, executor));
    }

    @Override
    public void removeListener(K listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void clear() {
        this.listeners.clear();
    }

    @Override
    public int size() {
        return this.listeners.size();
    }

    @Override
    public void forEach(Consumer<V> function) {
        for (ListenerEntry<V> entry : this.listeners.values()) {
            entry.executor.execute(() -> {
                try {
                    function.accept(entry.listener);
                }
                catch (Throwable e) {
                    ThreadUtils.checkInterrupted(e);
                    this.log.error(String.format("Listener (%s) threw an exception", entry.listener), e);
                }
            });
        }
    }

    MappingListenerManager(Function<K, V> mapper) {
        this.mapper = mapper;
    }
}

