/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.wrappedio.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.dynamic.BindingUtils;
import org.apache.hadoop.util.dynamic.DynMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicWrappedIO {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicWrappedIO.class);
    private static final String WRAPPED_IO_CLASSNAME = "org.apache.hadoop.io.wrappedio.WrappedIO";
    private static final String FILESYSTEM_OPEN_FILE = "fileSystem_openFile";
    private static final String BULKDELETE_DELETE = "bulkDelete_delete";
    private static final String BULKDELETE_PAGESIZE = "bulkDelete_pageSize";
    private static final String BYTE_BUFFER_POSITIONED_READABLE_READ_FULLY_AVAILABLE = "byteBufferPositionedReadable_readFullyAvailable";
    private static final String BYTE_BUFFER_POSITIONED_READABLE_READ_FULLY = "byteBufferPositionedReadable_readFully";
    private static final String PATH_CAPABILITIES_HAS_PATH_CAPABILITY = "pathCapabilities_hasPathCapability";
    private static final String STREAM_CAPABILITIES_HAS_CAPABILITY = "streamCapabilities_hasCapability";
    private static final DynamicWrappedIO INSTANCE = new DynamicWrappedIO();
    public static final String PARQUET_READ_POLICIES = "parquet, columnar, vector, random";
    private final boolean loaded;
    private final DynMethods.UnboundMethod bulkDeleteDeleteMethod;
    private final DynMethods.UnboundMethod bulkDeletePageSizeMethod;
    private final DynMethods.UnboundMethod fileSystemOpenFileMethod;
    private final DynMethods.UnboundMethod pathCapabilitiesHasPathCapabilityMethod;
    private final DynMethods.UnboundMethod streamCapabilitiesHasCapabilityMethod;
    private final DynMethods.UnboundMethod byteBufferPositionedReadableReadFullyAvailableMethod;
    private final DynMethods.UnboundMethod byteBufferPositionedReadableReadFullyMethod;

    public DynamicWrappedIO() {
        this(WRAPPED_IO_CLASSNAME);
    }

    public DynamicWrappedIO(String classname) {
        Class wrappedClass = BindingUtils.loadClass((String)classname);
        this.loaded = wrappedClass != null;
        this.bulkDeleteDeleteMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, List.class, (String)BULKDELETE_DELETE, (Class[])new Class[]{FileSystem.class, Path.class, Collection.class});
        this.bulkDeletePageSizeMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Integer.class, (String)BULKDELETE_PAGESIZE, (Class[])new Class[]{FileSystem.class, Path.class});
        this.fileSystemOpenFileMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, FSDataInputStream.class, (String)FILESYSTEM_OPEN_FILE, (Class[])new Class[]{FileSystem.class, Path.class, String.class, FileStatus.class, Long.class, Map.class});
        this.pathCapabilitiesHasPathCapabilityMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.TYPE, (String)PATH_CAPABILITIES_HAS_PATH_CAPABILITY, (Class[])new Class[]{Object.class, Path.class, String.class});
        this.streamCapabilitiesHasCapabilityMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.TYPE, (String)STREAM_CAPABILITIES_HAS_CAPABILITY, (Class[])new Class[]{Object.class, String.class});
        this.byteBufferPositionedReadableReadFullyAvailableMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Void.class, (String)BYTE_BUFFER_POSITIONED_READABLE_READ_FULLY_AVAILABLE, (Class[])new Class[]{InputStream.class});
        this.byteBufferPositionedReadableReadFullyMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Void.class, (String)BYTE_BUFFER_POSITIONED_READABLE_READ_FULLY, (Class[])new Class[]{InputStream.class, Long.TYPE, ByteBuffer.class});
    }

    public boolean loaded() {
        return this.loaded;
    }

    void requireAllMethodsAvailable() throws UnsupportedOperationException {
        DynMethods.UnboundMethod[] methods;
        for (DynMethods.UnboundMethod method : methods = new DynMethods.UnboundMethod[]{this.bulkDeleteDeleteMethod, this.bulkDeletePageSizeMethod, this.fileSystemOpenFileMethod, this.pathCapabilitiesHasPathCapabilityMethod, this.streamCapabilitiesHasCapabilityMethod, this.byteBufferPositionedReadableReadFullyAvailableMethod, this.byteBufferPositionedReadableReadFullyMethod}) {
            LOG.info("Checking method {}", (Object)method);
            if (BindingUtils.available((DynMethods.UnboundMethod)method)) continue;
            throw new UnsupportedOperationException("Unbound " + method);
        }
    }

    public boolean bulkDelete_available() {
        return BindingUtils.available((DynMethods.UnboundMethod)this.bulkDeleteDeleteMethod);
    }

    public int bulkDelete_pageSize(FileSystem fileSystem, Path path) throws IOException {
        BindingUtils.checkAvailable((DynMethods.UnboundMethod)this.bulkDeletePageSizeMethod);
        return (Integer)BindingUtils.extractIOEs(() -> (Integer)this.bulkDeletePageSizeMethod.invoke(null, new Object[]{fileSystem, path}));
    }

    public List<Map.Entry<Path, String>> bulkDelete_delete(FileSystem fs, Path base, Collection<Path> paths) throws IOException {
        BindingUtils.checkAvailable((DynMethods.UnboundMethod)this.bulkDeleteDeleteMethod);
        return (List)BindingUtils.extractIOEs(() -> (List)this.bulkDeleteDeleteMethod.invoke(null, new Object[]{fs, base, paths}));
    }

    public boolean fileSystem_openFile_available() {
        return BindingUtils.available((DynMethods.UnboundMethod)this.fileSystemOpenFileMethod);
    }

    public FSDataInputStream fileSystem_openFile(FileSystem fs, Path path, String policy, @Nullable FileStatus status, @Nullable Long length, @Nullable Map<String, String> options) throws IOException {
        BindingUtils.checkAvailable((DynMethods.UnboundMethod)this.fileSystemOpenFileMethod);
        return (FSDataInputStream)BindingUtils.extractIOEs(() -> (FSDataInputStream)this.fileSystemOpenFileMethod.invoke(null, new Object[]{fs, path, policy, status, length, options}));
    }

    public boolean pathCapabilities_hasPathCapability(Object fs, Path path, String capability) {
        if (!BindingUtils.available((DynMethods.UnboundMethod)this.pathCapabilitiesHasPathCapabilityMethod)) {
            return false;
        }
        return (Boolean)this.pathCapabilitiesHasPathCapabilityMethod.invoke(null, new Object[]{fs, path, capability});
    }

    public boolean streamCapabilities_hasCapability(Object object, String capability) {
        if (!BindingUtils.available((DynMethods.UnboundMethod)this.streamCapabilitiesHasCapabilityMethod)) {
            return false;
        }
        return (Boolean)this.streamCapabilitiesHasCapabilityMethod.invoke(null, new Object[]{object, capability});
    }

    public boolean byteBufferPositionedReadable_available() {
        return BindingUtils.available((DynMethods.UnboundMethod)this.byteBufferPositionedReadableReadFullyAvailableMethod);
    }

    public boolean byteBufferPositionedReadable_readFullyAvailable(InputStream in) throws IOException {
        if (BindingUtils.available((DynMethods.UnboundMethod)this.byteBufferPositionedReadableReadFullyAvailableMethod)) {
            return (Boolean)BindingUtils.extractIOEs(() -> (Boolean)this.byteBufferPositionedReadableReadFullyAvailableMethod.invoke(null, new Object[]{in}));
        }
        return false;
    }

    public void byteBufferPositionedReadable_readFully(InputStream in, long position, ByteBuffer buf) throws IOException {
        BindingUtils.checkAvailable((DynMethods.UnboundMethod)this.byteBufferPositionedReadableReadFullyMethod);
        BindingUtils.extractIOEs(() -> this.byteBufferPositionedReadableReadFullyMethod.invoke(null, new Object[]{in, position, buf}));
    }

    public static DynamicWrappedIO instance() {
        return INSTANCE;
    }

    public static boolean isAvailable() {
        return DynamicWrappedIO.instance().loaded();
    }

    public static FSDataInputStream openFile(FileSystem fs, FileStatus status, String readPolicies) throws IOException {
        return DynamicWrappedIO.openFileOnInstance(DynamicWrappedIO.instance(), fs, status, readPolicies);
    }

    @VisibleForTesting
    static FSDataInputStream openFileOnInstance(DynamicWrappedIO instance, FileSystem fs, FileStatus status, String readPolicies) throws IOException {
        FSDataInputStream stream;
        if (instance.fileSystem_openFile_available()) {
            LOG.debug("Opening file {} through fileSystem_openFile", (Object)status);
            stream = instance.fileSystem_openFile(fs, status.getPath(), readPolicies, status, null, null);
        } else {
            LOG.debug("Opening file {} through open()", (Object)status);
            stream = fs.open(status.getPath());
        }
        return stream;
    }
}

