/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.hadoop.conf.Configuration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStateTracker {
    private String job_trackingroot = null;
    private CuratorFramework zk;
    private String trackingnode;
    private String jobid;
    private static final Logger LOG = LoggerFactory.getLogger(JobStateTracker.class);

    public JobStateTracker(String node, CuratorFramework zk, boolean nodeIsTracker, String job_trackingpath) {
        this.zk = zk;
        if (nodeIsTracker) {
            this.trackingnode = node;
        } else {
            this.jobid = node;
        }
        this.job_trackingroot = job_trackingpath;
    }

    public void create() throws IOException {
        try {
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zk.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(this.job_trackingroot);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IOException("Unable to create parent nodes");
        }
        try {
            this.trackingnode = (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(this.makeTrackingZnode(), this.jobid.getBytes());
        }
        catch (Exception e) {
            throw new IOException("Unable to create " + this.makeTrackingZnode());
        }
    }

    public void delete() throws IOException {
        try {
            this.zk.delete().forPath(this.makeTrackingJobZnode(this.trackingnode));
        }
        catch (Exception e) {
            LOG.info("Couldn't delete " + this.makeTrackingJobZnode(this.trackingnode));
        }
    }

    public String getJobID() throws IOException {
        try {
            return new String((byte[])this.zk.getData().forPath(this.makeTrackingJobZnode(this.trackingnode)));
        }
        catch (Exception e) {
            throw new IOException("Node already deleted " + this.trackingnode, e);
        }
    }

    public String makeTrackingZnode() {
        return this.job_trackingroot + "/";
    }

    public String makeTrackingJobZnode(String nodename) {
        return this.job_trackingroot + "/" + nodename;
    }

    public static List<String> getTrackingJobs(Configuration conf, CuratorFramework zk) throws IOException {
        ArrayList<String> jobs = new ArrayList<String>();
        try {
            for (String myid : (List)zk.getChildren().forPath(conf.get("templeton.storage.root") + "/created")) {
                jobs.add(myid);
            }
        }
        catch (Exception e) {
            throw new IOException("Can't get tracking children", e);
        }
        return jobs;
    }
}

