/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=JSToIntegerAsIntNode.class)
public final class JSToIntegerAsIntNodeGen
extends JSToIntegerAsIntNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private StringData string_cache;

    private JSToIntegerAsIntNodeGen() {
    }

    @Override
    public int executeInt(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFFF) != 0) {
            JSToNumberNode toNumberNode_1;
            TruffleObject arg0Value_;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                return JSToIntegerAsIntNode.doInteger(arg0Value_2);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_3 = (Boolean)arg0Value;
                return JSToIntegerAsIntNode.doBoolean(arg0Value_3);
            }
            if ((state_0 & 0xC) != 0 && arg0Value instanceof SafeInteger) {
                arg0Value_ = (SafeInteger)arg0Value;
                if ((state_0 & 4) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                    return JSToIntegerAsIntNode.doSafeIntegerInt32Range((SafeInteger)arg0Value_);
                }
                if ((state_0 & 8) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                    return JSToIntegerAsIntNode.doSafeIntegerOther((SafeInteger)arg0Value_);
                }
            }
            if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x7000) >>> 12, arg0Value)) {
                double arg0Value_4 = JSTypesGen.asImplicitDouble((state_0 & 0x7000) >>> 12, arg0Value);
                return JSToIntegerAsIntNode.doDouble(arg0Value_4);
            }
            if ((state_0 & 0x60) != 0) {
                if ((state_0 & 0x20) != 0 && JSGuards.isUndefined(arg0Value)) {
                    return JSToIntegerAsIntNode.doUndefined(arg0Value);
                }
                if ((state_0 & 0x40) != 0 && JSGuards.isJSNull(arg0Value)) {
                    return JSToIntegerAsIntNode.doNull(arg0Value);
                }
            }
            if ((state_0 & 0x80) != 0 && arg0Value instanceof Symbol) {
                arg0Value_ = (Symbol)arg0Value;
                return this.doSymbol((Symbol)arg0Value_);
            }
            if ((state_0 & 0x100) != 0 && arg0Value instanceof BigInt) {
                arg0Value_ = (BigInt)arg0Value;
                return this.doBigInt((BigInt)arg0Value_);
            }
            if ((state_0 & 0x200) != 0 && arg0Value instanceof TruffleString) {
                arg0Value_ = (TruffleString)arg0Value;
                StringData s9_ = this.string_cache;
                if (s9_ != null) {
                    return this.doString((TruffleString)arg0Value_, s9_.nestedToIntegerNode_, s9_.stringToNumberNode_);
                }
            }
            if ((state_0 & 0x400) != 0 && arg0Value instanceof JSObject) {
                arg0Value_ = (JSObject)((Object)arg0Value);
                JSToNumberNode toNumberNode_ = this.toNumberNode;
                if (toNumberNode_ != null) {
                    return this.doJSObject((JSObject)arg0Value_, toNumberNode_);
                }
            }
            if ((state_0 & 0x800) != 0 && (toNumberNode_1 = this.toNumberNode) != null && (JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                return this.doJSOrForeignObject(arg0Value, toNumberNode_1);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private int executeAndSpecialize(Object arg0Value) {
        int doubleCast0;
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return JSToIntegerAsIntNode.doInteger(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 2;
            return JSToIntegerAsIntNode.doBoolean(arg0Value_);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                this.state_0_ = state_0 |= 4;
                return JSToIntegerAsIntNode.doSafeIntegerInt32Range(arg0Value_);
            }
            if (!JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                this.state_0_ = state_0 |= 8;
                return JSToIntegerAsIntNode.doSafeIntegerOther(arg0Value_);
            }
        }
        if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            state_0 |= doubleCast0 << 12;
            this.state_0_ = state_0 |= 0x10;
            return JSToIntegerAsIntNode.doDouble(arg0Value_);
        }
        if (JSGuards.isUndefined(arg0Value)) {
            this.state_0_ = state_0 |= 0x20;
            return JSToIntegerAsIntNode.doUndefined(arg0Value);
        }
        if (JSGuards.isJSNull(arg0Value)) {
            this.state_0_ = state_0 |= 0x40;
            return JSToIntegerAsIntNode.doNull(arg0Value);
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            this.state_0_ = state_0 |= 0x80;
            return this.doSymbol(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            this.state_0_ = state_0 |= 0x100;
            return this.doBigInt(arg0Value_);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString)arg0Value;
            StringData s9_ = (StringData)this.insert(new StringData());
            JSToIntegerAsIntNode nestedToIntegerNode__ = (JSToIntegerAsIntNode)s9_.insert(JSToIntegerAsIntNode.create());
            Objects.requireNonNull(nestedToIntegerNode__, "Specialization 'doString(TruffleString, JSToIntegerAsIntNode, JSStringToNumberNode)' cache 'nestedToIntegerNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s9_.nestedToIntegerNode_ = nestedToIntegerNode__;
            JSStringToNumberNode stringToNumberNode__ = (JSStringToNumberNode)s9_.insert(JSStringToNumberNode.create());
            Objects.requireNonNull(stringToNumberNode__, "Specialization 'doString(TruffleString, JSToIntegerAsIntNode, JSStringToNumberNode)' cache 'stringToNumberNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s9_.stringToNumberNode_ = stringToNumberNode__;
            VarHandle.storeStoreFence();
            this.string_cache = s9_;
            this.state_0_ = state_0 |= 0x200;
            return this.doString(arg0Value_, nestedToIntegerNode__, stringToNumberNode__);
        }
        if ((state_0 & 0x800) == 0 && arg0Value instanceof JSObject) {
            JSToNumberNode toNumberNode_;
            JSObject arg0Value_ = (JSObject)((Object)arg0Value);
            JSToNumberNode toNumberNode__shared = this.toNumberNode;
            if (toNumberNode__shared != null) {
                toNumberNode_ = toNumberNode__shared;
            } else {
                toNumberNode_ = (JSToNumberNode)this.insert(JSToNumberNode.create());
                if (toNumberNode_ == null) {
                    throw new IllegalStateException("Specialization 'doJSObject(JSObject, JSToNumberNode)' contains a shared cache with name 'toNumberNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumberNode == null) {
                VarHandle.storeStoreFence();
                this.toNumberNode = toNumberNode_;
            }
            this.state_0_ = state_0 |= 0x400;
            return this.doJSObject(arg0Value_, toNumberNode_);
        }
        if (JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value)) {
            JSToNumberNode toNumberNode_1;
            JSToNumberNode toNumberNode_1_shared = this.toNumberNode;
            if (toNumberNode_1_shared != null) {
                toNumberNode_1 = toNumberNode_1_shared;
            } else {
                toNumberNode_1 = (JSToNumberNode)this.insert(JSToNumberNode.create());
                if (toNumberNode_1 == null) {
                    throw new IllegalStateException("Specialization 'doJSOrForeignObject(Object, JSToNumberNode)' contains a shared cache with name 'toNumberNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumberNode == null) {
                VarHandle.storeStoreFence();
                this.toNumberNode = toNumberNode_1;
            }
            state_0 &= 0xFFFFFBFF;
            this.state_0_ = state_0 |= 0x800;
            return this.doJSOrForeignObject(arg0Value, toNumberNode_1);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xFFF & (state_0 & 0xFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        JSToNumberNode toNumberNode_1;
        ArrayList<List<Object>> cached;
        JSToNumberNode toNumberNode_;
        Object[] data = new Object[13];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeIntegerInt32Range";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doSafeIntegerOther";
        if ((state_0 & 8) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state_0 & 0x10) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        if ((state_0 & 0x20) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doNull";
        if ((state_0 & 0x40) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state_0 & 0x80) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 0x100) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state_0 & 0x200) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached2 = new ArrayList<List<Object>>();
            StringData s9_ = this.string_cache;
            if (s9_ != null) {
                cached2.add(Arrays.asList(new Object[]{s9_.nestedToIntegerNode_, s9_.stringToNumberNode_}));
            }
            s[2] = cached2;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state_0 & 0x400) != 0 && (toNumberNode_ = this.toNumberNode) != null) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(new Object[]{this.toNumberNode}));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (state_0 & 0x800) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doJSOrForeignObject";
        if ((state_0 & 0x800) != 0 && (toNumberNode_1 = this.toNumberNode) != null) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[]{this.toNumberNode}));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[12] = s;
        return Introspection.Provider.create((Object[])data);
    }

    @NeverDefault
    public static JSToIntegerAsIntNode create() {
        return new JSToIntegerAsIntNodeGen();
    }

    @GeneratedBy(value=JSToIntegerAsIntNode.class)
    @DenyReplace
    private static final class StringData
    extends Node {
        @Node.Child
        JSToIntegerAsIntNode nestedToIntegerNode_;
        @Node.Child
        JSStringToNumberNode stringToNumberNode_;

        StringData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

