/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;

@GenerateUncached
abstract class JSStringToNumberNoTrimNode
extends JavaScriptBaseNode {
    static final int PREFIX_LENGTH = 2;
    static final int SAFE_HEX_DIGITS = 15;
    static final int SAFE_OCTAL_DIGITS = 19;
    static final int SAFE_BINARY_DIGITS = 55;
    static final int MAX_SAFE_INTEGER_LENGTH = 17;
    static final int SMALL_INT_LENGTH = 9;

    JSStringToNumberNoTrimNode() {
    }

    abstract double executeNoTrim(TruffleString var1);

    protected static char charAt(TruffleString s, int i, TruffleString.ReadCharUTF16Node readChar) {
        return Strings.charAt(readChar, s, i);
    }

    protected static boolean startsWithI(TruffleString input, TruffleString.ReadCharUTF16Node readChar) {
        return Strings.length(input) >= Strings.length(Strings.INFINITY) && Strings.length(input) <= Strings.length(Strings.INFINITY) + 1 && (JSStringToNumberNoTrimNode.charAt(input, 0, readChar) == 'I' || JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'I');
    }

    protected static boolean startsWithValidDouble(TruffleString input, TruffleString.ReadCharUTF16Node readChar) {
        char firstChar = JSStringToNumberNoTrimNode.charAt(input, 0, readChar);
        if (JSRuntime.isAsciiDigit(firstChar) || firstChar == '-' || firstChar == '.' || firstChar == '+') {
            if (Strings.length(input) >= 2) {
                char secondChar = JSStringToNumberNoTrimNode.charAt(input, 1, readChar);
                return JSRuntime.isAsciiDigit(secondChar) || secondChar == '.' || secondChar == 'e' || secondChar == 'E';
            }
            return true;
        }
        return false;
    }

    protected static boolean startsWithValidInt(TruffleString input, TruffleString.ReadCharUTF16Node readChar) {
        char firstChar = JSStringToNumberNoTrimNode.charAt(input, 0, readChar);
        return !(!JSRuntime.isAsciiDigit(firstChar) && firstChar != '-' && firstChar != '+' || Strings.length(input) >= 2 && !JSRuntime.isAsciiDigit(JSStringToNumberNoTrimNode.charAt(input, 1, readChar)));
    }

    protected static boolean allDigits(TruffleString input, int maxLength, TruffleString.ReadCharUTF16Node readChar) {
        assert (Strings.length(input) <= maxLength);
        for (int i = 0; i < maxLength; ++i) {
            if (i >= Strings.length(input)) {
                return true;
            }
            if (JSRuntime.isAsciiDigit(JSStringToNumberNoTrimNode.charAt(input, i, readChar))) continue;
            return false;
        }
        return false;
    }

    protected static boolean isHex(TruffleString input, TruffleString.ReadCharUTF16Node readChar) {
        return Strings.length(input) >= 2 && JSStringToNumberNoTrimNode.charAt(input, 0, readChar) == '0' && (JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'x' || JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'X');
    }

    protected static boolean isOctal(TruffleString input, TruffleString.ReadCharUTF16Node readChar) {
        return Strings.length(input) >= 2 && JSStringToNumberNoTrimNode.charAt(input, 0, readChar) == '0' && (JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'o' || JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'O');
    }

    protected static boolean isBinary(TruffleString input, TruffleString.ReadCharUTF16Node readChar) {
        return Strings.length(input) >= 2 && JSStringToNumberNoTrimNode.charAt(input, 0, readChar) == '0' && (JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'b' || JSStringToNumberNoTrimNode.charAt(input, 1, readChar) == 'B');
    }

    @Specialization(guards={"stringLength(input) == 0"})
    protected static double doLengthIsZero(TruffleString input) {
        return 0.0;
    }

    @Specialization(guards={"startsWithI(input, readChar)"}, limit="1")
    protected static double doInfinity(TruffleString input, @Bind(value="this") Node node, @Cached InlinedConditionProfile endsWithInfinity, @Cached TruffleString.RegionEqualByteIndexNode regionEqualsNode, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        if (endsWithInfinity.profile(node, Strings.endsWith(regionEqualsNode, input, Strings.INFINITY))) {
            return JSRuntime.identifyInfinity(JSStringToNumberNoTrimNode.charAt(input, 0, readChar), Strings.length(input));
        }
        return Double.NaN;
    }

    @Specialization(guards={"stringLength(input) > 0", "!startsWithI(input, readChar)", "!startsWithValidDouble(input, readChar)", "!isHex(input, readChar)", "!isOctal(input, readChar)", "!isBinary(input, readChar)"}, limit="1")
    protected static double doNaN(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        return Double.NaN;
    }

    @Specialization(guards={"isHex(input, readChar)", "stringLength(input) <= SAFE_HEX_DIGITS"}, limit="1")
    @CompilerDirectives.TruffleBoundary
    protected static double doHexSafe(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        return JSStringToNumberNoTrimNode.safeIntegerToDouble(JSRuntime.parseSafeInteger(input, 2, Strings.length(input), 16));
    }

    @Specialization(guards={"isHex(input, readChar)", "stringLength(input) > SAFE_HEX_DIGITS"}, limit="1")
    @CompilerDirectives.TruffleBoundary
    protected static double doHex(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        try {
            return Strings.parseBigInteger(Strings.lazySubstring(input, 2), 16).doubleValue();
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @Specialization(guards={"isOctal(input, readChar)", "stringLength(input) <= SAFE_OCTAL_DIGITS"}, limit="1")
    @CompilerDirectives.TruffleBoundary
    protected static double doOctalSafe(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        return JSStringToNumberNoTrimNode.safeIntegerToDouble(JSRuntime.parseSafeInteger(input, 2, Strings.length(input), 8));
    }

    @Specialization(guards={"isOctal(input, readChar)", "stringLength(input) > SAFE_OCTAL_DIGITS"}, limit="1")
    @CompilerDirectives.TruffleBoundary
    protected static double doOctal(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        try {
            return Strings.parseBigInteger(Strings.lazySubstring(input, 2), 8).doubleValue();
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @Specialization(guards={"isBinary(input, readChar)", "stringLength(input) <= SAFE_BINARY_DIGITS"}, limit="1")
    @CompilerDirectives.TruffleBoundary
    protected static double doBinarySafe(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        return JSStringToNumberNoTrimNode.safeIntegerToDouble(JSRuntime.parseSafeInteger(input, 2, Strings.length(input), 2));
    }

    @Specialization(guards={"isBinary(input, readChar)", "stringLength(input) > SAFE_BINARY_DIGITS"}, limit="1")
    @CompilerDirectives.TruffleBoundary
    protected static double doBinary(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        try {
            return Strings.parseBigInteger(Strings.lazySubstring(input, 2), 2).doubleValue();
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @Specialization(guards={"stringLength(input) > 0", "stringLength(input) <= SMALL_INT_LENGTH", "allDigits(input, SMALL_INT_LENGTH, readChar)"}, limit="1")
    protected static double doSmallPosInt(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        int result = 0;
        int len = Strings.length(input);
        for (int pos = 0; pos < len; ++pos) {
            char c = JSStringToNumberNoTrimNode.charAt(input, pos, readChar);
            assert (JSRuntime.isAsciiDigit(c));
            result *= 10;
            result += c - 48;
        }
        assert (result >= 0 && JSStringToNumberNoTrimNode.checkLongResult(result, input));
        return result;
    }

    @Specialization(guards={"stringLength(input) > 0", "stringLength(input) <= MAX_SAFE_INTEGER_LENGTH", "startsWithValidInt(input, readChar)"}, rewriteOn={SlowPathException.class}, replaces={"doSmallPosInt"}, limit="1")
    protected static double doInteger(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) throws SlowPathException {
        long result = JSRuntime.parseSafeInteger(input);
        if (result == Long.MIN_VALUE) {
            throw JSNodeUtil.slowPathException();
        }
        assert (JSStringToNumberNoTrimNode.checkLongResult(result, input));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"stringLength(input) > 0", "startsWithValidDouble(input, readChar)"}, replaces={"doInteger"}, limit="1")
    protected static double doDouble(TruffleString input, @Cached @Cached.Shared TruffleString.ReadCharUTF16Node readChar) {
        return JSRuntime.parseDoubleOrNaN(input);
    }

    private static double safeIntegerToDouble(long result) {
        if (result == Long.MIN_VALUE) {
            return Double.NaN;
        }
        assert (JSRuntime.isSafeInteger(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean checkLongResult(long result, TruffleString input) {
        return Double.compare(result, JSRuntime.parseDoubleOrNaN(input)) == 0;
    }
}

