/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;

public class Converter {
    Exec exec;
    boolean trace = false;

    Converter(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
    }

    String dataType(HplsqlParser.DtypeContext type, HplsqlParser.Dtype_lenContext len) {
        Object t = this.exec.getText(type);
        boolean enclosed = false;
        if (((String)t).charAt(0) == '[') {
            t = ((String)t).substring(1, ((String)t).length() - 1);
            enclosed = true;
        }
        if (((String)t).equalsIgnoreCase("BIT")) {
            t = "TINYINT";
        } else if (!((String)t).equalsIgnoreCase("INT") && !((String)t).equalsIgnoreCase("INTEGER")) {
            if (((String)t).equalsIgnoreCase("INT2")) {
                t = "SMALLINT";
            } else if (((String)t).equalsIgnoreCase("INT4")) {
                t = "INT";
            } else if (((String)t).equalsIgnoreCase("INT8")) {
                t = "BIGINT";
            } else if (((String)t).equalsIgnoreCase("DATETIME") || ((String)t).equalsIgnoreCase("SMALLDATETIME")) {
                t = "TIMESTAMP";
            } else if ((((String)t).equalsIgnoreCase("VARCHAR") || ((String)t).equalsIgnoreCase("NVARCHAR")) && len.T_MAX() != null) {
                t = "STRING";
            } else if (((String)t).equalsIgnoreCase("VARCHAR2") || ((String)t).equalsIgnoreCase("NCHAR") || ((String)t).equalsIgnoreCase("NVARCHAR") || ((String)t).equalsIgnoreCase("TEXT")) {
                t = "STRING";
            } else if (((String)t).equalsIgnoreCase("NUMBER") || ((String)t).equalsIgnoreCase("NUMERIC")) {
                t = "DECIMAL";
                if (len != null) {
                    t = (String)t + this.exec.getText(len);
                }
            } else {
                if (len != null) {
                    if (!enclosed) {
                        return this.exec.getText(type, type.getStart(), len.getStop());
                    }
                    return (String)t + this.exec.getText(len, len.getStart(), len.getStop());
                }
                if (!enclosed) {
                    return this.exec.getText(type, type.getStart(), type.getStop());
                }
            }
        }
        return t;
    }
}

