/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.accumulo.start.classloader.AccumuloClassLoader;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static ClassLoader classLoader;
    private static Class<?> vfsClassLoader;
    private static Map<String, KeywordExecutable> servicesMap;

    public static void main(String[] args) {
        try {
            ClassLoader loader = Main.getClassLoader();
            Class<?> confClass = null;
            try {
                confClass = AccumuloClassLoader.getClassLoader().loadClass("org.apache.hadoop.conf.Configuration");
            }
            catch (ClassNotFoundException e) {
                log.error("Unable to find Hadoop Configuration class on classpath, check configuration.", (Throwable)e);
                System.exit(1);
            }
            Object conf = null;
            try {
                conf = confClass.newInstance();
            }
            catch (Exception e) {
                log.error("Error creating new instance of Hadoop Configuration", (Throwable)e);
                System.exit(1);
            }
            try {
                Method getClassByNameOrNullMethod = conf.getClass().getMethod("getClassByNameOrNull", String.class);
                getClassByNameOrNullMethod.invoke(conf, "org.apache.hadoop.mapred.JobConf");
                getClassByNameOrNullMethod.invoke(conf, "org.apache.hadoop.mapred.JobConfigurable");
            }
            catch (Exception e) {
                log.error("Error pre-loading JobConf and JobConfigurable classes, VFS classloader with system classes in HDFS may not work correctly", (Throwable)e);
                System.exit(1);
            }
            if (args.length == 0) {
                Main.printUsage();
                System.exit(1);
            }
            String keywordOrClassName = args[0];
            KeywordExecutable keywordExec = Main.getExecutables(loader).get(keywordOrClassName);
            if (keywordExec != null) {
                Main.execKeyword(keywordExec, Main.stripArgs(args, 1));
            } else {
                Main.execMainClassName(keywordOrClassName, Main.stripArgs(args, 1));
            }
        }
        catch (Throwable t) {
            log.error("Uncaught exception", t);
            System.exit(1);
        }
    }

    public static synchronized ClassLoader getClassLoader() {
        if (classLoader == null) {
            try {
                ClassLoader clTmp;
                classLoader = clTmp = (ClassLoader)Main.getVFSClassLoader().getMethod("getClassLoader", new Class[0]).invoke(null, new Object[0]);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Problem initializing the class loader", (Throwable)e);
                System.exit(1);
            }
        }
        return classLoader;
    }

    public static synchronized Class<?> getVFSClassLoader() throws IOException, ClassNotFoundException {
        if (vfsClassLoader == null) {
            Thread.currentThread().setContextClassLoader(AccumuloClassLoader.getClassLoader());
            Class<?> vfsClassLoaderTmp = AccumuloClassLoader.getClassLoader().loadClass("org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader");
            vfsClassLoader = vfsClassLoaderTmp;
        }
        return vfsClassLoader;
    }

    private static void execKeyword(final KeywordExecutable keywordExec, final String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    keywordExec.execute(args);
                }
                catch (Exception e) {
                    Main.die(e);
                }
            }
        };
        Main.startThread(r, keywordExec.keyword());
    }

    private static void execMainClassName(String className, String[] args) {
        Class<?> classWithMain = null;
        try {
            classWithMain = Main.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Classname " + className + " not found.  Please make sure you use the wholly qualified package name.");
            System.exit(1);
        }
        Main.execMainClass(classWithMain, args);
    }

    public static void execMainClass(Class<?> classWithMain, final String[] args) {
        Method main = null;
        try {
            main = classWithMain.getMethod("main", args.getClass());
        }
        catch (Throwable t) {
            log.error("Could not run main method on '" + classWithMain.getName() + "'.", t);
        }
        if (main == null || !Modifier.isPublic(main.getModifiers()) || !Modifier.isStatic(main.getModifiers())) {
            System.out.println(classWithMain.getName() + " must implement a public static void main(String args[]) method");
            System.exit(1);
        }
        final Method finalMain = main;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    String[] thisIsJustOneArgument = args;
                    finalMain.invoke(null, new Object[]{thisIsJustOneArgument});
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null) {
                        Main.die(e.getCause());
                    } else {
                        Main.die(e);
                    }
                }
                catch (Exception e) {
                    Main.die(e);
                }
            }
        };
        Main.startThread(r, classWithMain.getName());
    }

    public static String[] stripArgs(String[] originalArgs, int numToStrip) {
        int newSize = originalArgs.length - numToStrip;
        String[] newArgs = new String[newSize];
        System.arraycopy(originalArgs, numToStrip, newArgs, 0, newSize);
        return newArgs;
    }

    private static void startThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        t.setContextClassLoader(Main.getClassLoader());
        t.start();
    }

    private static void die(Throwable t) {
        log.error("Thread '" + Thread.currentThread().getName() + "' died.", t);
        System.exit(1);
    }

    public static void printUsage() {
        TreeSet<String> keywords = new TreeSet<String>(Main.getExecutables(Main.getClassLoader()).keySet());
        keywords.remove("jar");
        keywords.add("jar <jar> [<main class>] args");
        String prefix = "";
        String kwString = "";
        for (String kw : keywords) {
            kwString = kwString + prefix + kw;
            prefix = " | ";
        }
        System.out.println("accumulo " + kwString + " | <accumulo class> args");
    }

    public static synchronized Map<String, KeywordExecutable> getExecutables(ClassLoader cl) {
        if (servicesMap == null) {
            servicesMap = Main.checkDuplicates(ServiceLoader.load(KeywordExecutable.class, cl));
        }
        return servicesMap;
    }

    public static Map<String, KeywordExecutable> checkDuplicates(Iterable<? extends KeywordExecutable> services) {
        TreeSet<String> blacklist = new TreeSet<String>();
        TreeMap<String, KeywordExecutable> results = new TreeMap<String, KeywordExecutable>();
        for (KeywordExecutable keywordExecutable : services) {
            String keyword = keywordExecutable.keyword();
            if (blacklist.contains(keyword)) {
                Main.warnDuplicate(keywordExecutable);
                continue;
            }
            if (results.containsKey(keyword)) {
                blacklist.add(keyword);
                Main.warnDuplicate((KeywordExecutable)results.remove(keyword));
                Main.warnDuplicate(keywordExecutable);
                continue;
            }
            results.put(keywordExecutable.keyword(), keywordExecutable);
        }
        return Collections.unmodifiableSortedMap(results);
    }

    private static void warnDuplicate(KeywordExecutable service) {
        log.warn("Ambiguous duplicate binding for keyword '" + service.keyword() + "' found: " + service.getClass().getName());
    }

    public static Class<?> loadClassFromJar(String[] args, JarFile f, ClassLoader cl) throws ClassNotFoundException, IOException {
        String mainClass;
        ClassNotFoundException explicitNotFound = null;
        if (args.length >= 2) {
            try {
                return cl.loadClass(args[1]);
            }
            catch (ClassNotFoundException cnfe) {
                explicitNotFound = cnfe;
            }
        }
        if ((mainClass = f.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) == null) {
            if (explicitNotFound != null) {
                throw explicitNotFound;
            }
            throw new ClassNotFoundException("No main class was specified, and the JAR manifest does not specify one");
        }
        return cl.loadClass(mainClass);
    }
}

