/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hive.iceberg.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.rest.HTTPHeaders;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HTTPHeaders.HTTPHeader", generator="Immutables")
@Immutable
public final class ImmutableHTTPHeader
implements HTTPHeaders.HTTPHeader {
    private final String name;
    private final String value;

    private ImmutableHTTPHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    public final ImmutableHTTPHeader withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableHTTPHeader.validate(new ImmutableHTTPHeader(newValue, this.value));
    }

    public final ImmutableHTTPHeader withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return ImmutableHTTPHeader.validate(new ImmutableHTTPHeader(this.name, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHTTPHeader && this.equalTo(0, (ImmutableHTTPHeader)another);
    }

    private boolean equalTo(int synthetic, ImmutableHTTPHeader another) {
        return this.name.equals(another.name) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "HTTPHeader{name=" + this.name + ", value=****}";
    }

    private static ImmutableHTTPHeader validate(ImmutableHTTPHeader instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHTTPHeader copyOf(HTTPHeaders.HTTPHeader instance) {
        if (instance instanceof ImmutableHTTPHeader) {
            return (ImmutableHTTPHeader)instance;
        }
        return ImmutableHTTPHeader.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HTTPHeaders.HTTPHeader", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HTTPHeaders.HTTPHeader instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableHTTPHeader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHTTPHeader.validate(new ImmutableHTTPHeader(this.name, this.value));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build HTTPHeader, some of required attributes are not set " + attributes;
        }
    }
}

