/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.SizeBasedFileRewriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.PropertyUtil;

@Deprecated
public abstract class SizeBasedDataRewriter
extends SizeBasedFileRewriter<FileScanTask, DataFile> {
    public static final String DELETE_FILE_THRESHOLD = "delete-file-threshold";
    public static final int DELETE_FILE_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    public static final String DELETE_RATIO_THRESHOLD = "delete-ratio-threshold";
    public static final double DELETE_RATIO_THRESHOLD_DEFAULT = 0.3;
    private int deleteFileThreshold;
    private double deleteRatioThreshold;

    protected SizeBasedDataRewriter(Table table) {
        super(table);
    }

    @Override
    public Set<String> validOptions() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(super.validOptions())).add(DELETE_FILE_THRESHOLD)).add(DELETE_RATIO_THRESHOLD)).build();
    }

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.deleteFileThreshold = this.deleteFileThreshold(options);
        this.deleteRatioThreshold = this.deleteRatioThreshold(options);
    }

    private double deleteRatioThreshold(Map<String, String> options) {
        double value = PropertyUtil.propertyAsDouble(options, DELETE_RATIO_THRESHOLD, 0.3);
        Preconditions.checkArgument(value > 0.0, "'%s' is set to %s but must be > 0", (Object)DELETE_RATIO_THRESHOLD, (Object)value);
        Preconditions.checkArgument(value <= 1.0, "'%s' is set to %s but must be <= 1", (Object)DELETE_RATIO_THRESHOLD, (Object)value);
        return value;
    }

    @Override
    protected Iterable<FileScanTask> filterFiles(Iterable<FileScanTask> tasks) {
        return Iterables.filter(tasks, this::shouldRewrite);
    }

    private boolean shouldRewrite(FileScanTask task) {
        return this.wronglySized(task) || this.tooManyDeletes(task) || this.tooHighDeleteRatio(task);
    }

    private boolean tooManyDeletes(FileScanTask task) {
        return task.deletes() != null && task.deletes().size() >= this.deleteFileThreshold;
    }

    @Override
    protected Iterable<List<FileScanTask>> filterFileGroups(List<List<FileScanTask>> groups) {
        return Iterables.filter(groups, this::shouldRewrite);
    }

    private boolean shouldRewrite(List<FileScanTask> group) {
        return this.enoughInputFiles(group) || this.enoughContent(group) || this.tooMuchContent(group) || this.anyTaskHasTooManyDeletes(group) || this.anyTaskHasTooHighDeleteRatio(group);
    }

    private boolean anyTaskHasTooManyDeletes(List<FileScanTask> group) {
        return group.stream().anyMatch(this::tooManyDeletes);
    }

    private boolean anyTaskHasTooHighDeleteRatio(List<FileScanTask> group) {
        return group.stream().anyMatch(this::tooHighDeleteRatio);
    }

    private boolean tooHighDeleteRatio(FileScanTask task) {
        if (task.deletes() == null || task.deletes().isEmpty()) {
            return false;
        }
        long knownDeletedRecordCount = task.deletes().stream().filter(ContentFileUtil::isFileScoped).mapToLong(ContentFile::recordCount).sum();
        double deletedRecords = Math.min(knownDeletedRecordCount, ((DataFile)task.file()).recordCount());
        double deleteRatio = deletedRecords / (double)((DataFile)task.file()).recordCount();
        return deleteRatio >= this.deleteRatioThreshold;
    }

    @Override
    protected long defaultTargetFileSize() {
        return PropertyUtil.propertyAsLong(this.table().properties(), "write.target-file-size-bytes", 0x20000000L);
    }

    private int deleteFileThreshold(Map<String, String> options) {
        int value = PropertyUtil.propertyAsInt(options, DELETE_FILE_THRESHOLD, Integer.MAX_VALUE);
        Preconditions.checkArgument(value >= 0, "'%s' is set to %s but must be >= 0", (Object)DELETE_FILE_THRESHOLD, value);
        return value;
    }
}

