/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.Partition;
import org.apache.hive.kudu.org.apache.kudu.client.RemoteTablet;
import org.apache.hive.kudu.org.apache.kudu.consensus.Metadata;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedTablet {
    private final Partition partition;
    private final byte[] tabletId;
    private final List<Replica> replicas;

    @InterfaceAudience.LimitedPrivate(value={"Tests"})
    public LocatedTablet(RemoteTablet tablet) {
        this.partition = tablet.getPartition();
        this.tabletId = tablet.getTabletIdAsBytes();
        this.replicas = tablet.getReplicas();
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    public Partition getPartition() {
        return this.partition;
    }

    @Deprecated
    public byte[] getStartKey() {
        return this.getPartition().getPartitionKeyStart();
    }

    @Deprecated
    public byte[] getEndKey() {
        return this.getPartition().getPartitionKeyEnd();
    }

    public byte[] getTabletId() {
        return this.tabletId;
    }

    public Replica getLeaderReplica() {
        return this.getOneOfRoleOrNull(Metadata.RaftPeerPB.Role.LEADER);
    }

    private Replica getOneOfRoleOrNull(Metadata.RaftPeerPB.Role role) {
        for (Replica r : this.replicas) {
            if (!r.getRoleAsEnum().equals(role)) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return Bytes.pretty(this.tabletId) + " " + this.partition.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Replica {
        private final String host;
        private final Integer port;
        private final Metadata.RaftPeerPB.Role role;
        private final String dimensionLabel;

        Replica(String host, Integer port, Metadata.RaftPeerPB.Role role, String dimensionLabel) {
            this.host = host;
            this.port = port;
            this.role = role;
            this.dimensionLabel = dimensionLabel;
        }

        public String getRpcHost() {
            return this.host;
        }

        public Integer getRpcPort() {
            return this.port;
        }

        Metadata.RaftPeerPB.Role getRoleAsEnum() {
            return this.role;
        }

        public String getRole() {
            return this.role.toString();
        }

        public String getDimensionLabel() {
            return this.dimensionLabel;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Replica(host=").append(this.host == null ? "null" : this.host);
            buf.append(", port=").append(this.port == null ? "null" : this.port.toString());
            buf.append(", role=").append(this.getRole());
            buf.append(", dimensionLabel=").append(this.dimensionLabel == null ? "null" : this.dimensionLabel);
            buf.append(')');
            return buf.toString();
        }
    }
}

