/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.spitter;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;

public class DecimalIntervalSplitter
implements IntervalSplitter {
    @Override
    public List<MutablePair<String, String>> getIntervals(String lowerBound, String upperBound, int numPartitions, TypeInfo typeInfo) {
        ArrayList<MutablePair<String, String>> intervals = new ArrayList<MutablePair<String, String>>();
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
        int scale = decimalTypeInfo.getScale();
        BigDecimal decimalLower = new BigDecimal(lowerBound);
        BigDecimal decimalUpper = new BigDecimal(upperBound);
        BigDecimal decimalInterval = decimalUpper.subtract(decimalLower).divide(new BigDecimal(numPartitions), MathContext.DECIMAL64);
        for (int i = 0; i < numPartitions; ++i) {
            BigDecimal splitDecimalUpper;
            BigDecimal splitDecimalLower = decimalLower.add(decimalInterval.multiply(new BigDecimal(i))).setScale(scale, RoundingMode.HALF_EVEN);
            if (splitDecimalLower.compareTo(splitDecimalUpper = decimalLower.add(decimalInterval.multiply(new BigDecimal(i + 1))).setScale(scale, RoundingMode.HALF_EVEN)) >= 0) continue;
            intervals.add((MutablePair<String, String>)new MutablePair((Object)splitDecimalLower.toPlainString(), (Object)splitDecimalUpper.toPlainString()));
        }
        return intervals;
    }
}

