/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.SQLFunctionMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class SQLFunctionMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression ignore, List<SQLExpression> args) {
        if (args == null || args.size() < 1) {
            throw new NucleusUserException("Cannot invoke SQL_function() without first argument defining the function");
        }
        SQLExpression expr = args.get(0);
        if (!(expr instanceof StringLiteral)) {
            throw new NucleusUserException("Cannot use SQL_function() without first argument defining the function");
        }
        String sql = (String)((StringLiteral)expr).getValue();
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        if (args.size() > 1) {
            funcArgs.addAll(args.subList(1, args.size()));
        }
        SQLFunctionMapping m = new SQLFunctionMapping();
        m.initialize(stmt.getRDBMSManager(), null);
        return new ObjectExpression(stmt, m, sql, funcArgs);
    }
}

