/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.util.StringUtils;

public class FloatingPointLiteral
extends NumericExpression
implements SQLLiteral {
    private final BigDecimal value;

    public FloatingPointLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Float) {
            this.value = new BigDecimal(((Float)value).toString());
        } else if (value instanceof Double) {
            this.value = new BigDecimal(((Double)value).toString());
        } else if (value instanceof BigDecimal) {
            this.value = (BigDecimal)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, (Object)String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(expr, Expression.OP_EQ, literal);
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, (Object)String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(expr, Expression.OP_NOTEQ, literal);
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, (Object)String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, (Object)String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, (Object)String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, (Object)String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    @Override
    public SQLExpression add(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_ADD, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.add(((FloatingPointLiteral)expr).value), null);
        }
        return super.add(expr);
    }

    @Override
    public SQLExpression sub(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_SUB, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.subtract(((FloatingPointLiteral)expr).value), null);
        }
        return super.sub(expr);
    }

    @Override
    public SQLExpression mul(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_MUL, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.multiply(((FloatingPointLiteral)expr).value), null);
        }
        return super.mul(expr);
    }

    @Override
    public SQLExpression div(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_DIV, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.divide(((FloatingPointLiteral)expr).value, RoundingMode.DOWN), null);
        }
        return super.div(expr);
    }

    @Override
    public SQLExpression neg() {
        return new FloatingPointLiteral(this.stmt, this.mapping, this.value.negate(), null);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        this.st.append(StringUtils.exponentialFormatBigDecimal((BigDecimal)this.value));
    }
}

