/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntConsumer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.flush.BatchingFlushProcess;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.RequestUtil;
import org.datanucleus.store.rdbms.request.StatementMappingDefinition;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class DeleteRequest
extends Request {
    private final List<MappingCallbacks> mappingCallbacks;
    private final String deleteStmt;
    private final String deleteStmtOptimistic;
    private final String softDeleteStmt;
    private StatementMappingDefinition mappingStatementIndex;
    private StatementMappingIndex multitenancyStatementMapping;
    private final int[] whereFieldNumbers;
    private final AbstractMemberMetaData[] oneToOneNonOwnerFields;
    protected AbstractClassMetaData cmd = null;
    protected VersionMetaData versionMetaData = null;
    private final BitSet nullPkFields;
    protected boolean versionChecks = false;

    public DeleteRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr, BitSet nullPkFields) {
        super(table);
        this.nullPkFields = nullPkFields;
        this.cmd = cmd;
        this.versionMetaData = table.getVersionMetaData();
        if (this.versionMetaData != null && this.versionMetaData.getStrategy() != VersionStrategy.NONE) {
            this.versionChecks = true;
        }
        this.mappingStatementIndex = new StatementMappingDefinition();
        DeleteMappingConsumer consumer = new DeleteMappingConsumer(clr, cmd);
        table.provideNonPrimaryKeyMappings(consumer);
        consumer.setWhereClauseConsumption();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            table.providePrimaryKeyMappings(consumer);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            table.provideSurrogateMapping(SurrogateColumnType.DATASTORE_ID, consumer);
        } else {
            AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
            table.provideMappingsForMembers(consumer, mmds, false);
        }
        table.provideSurrogateMapping(SurrogateColumnType.MULTITENANCY, consumer);
        this.deleteStmt = consumer.getStatement();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getMemberName() != null) {
                AbstractMemberMetaData[] versionFmds = new AbstractMemberMetaData[]{cmd.getMetaDataForMember(this.versionMetaData.getMemberName())};
                table.provideMappingsForMembers(consumer, versionFmds, false);
            } else {
                table.provideSurrogateMapping(SurrogateColumnType.VERSION, consumer);
            }
        }
        this.deleteStmtOptimistic = consumer.getStatement();
        this.softDeleteStmt = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null ? consumer.getSoftDeleteStatement() : null;
        this.whereFieldNumbers = consumer.getWhereFieldNumbers();
        this.mappingCallbacks = consumer.getMappingCallBacks();
        this.oneToOneNonOwnerFields = consumer.getOneToOneNonOwnerFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DNStateManager sm) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052210", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), this.table}));
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        HashSet<Object> relatedObjectsToDelete = null;
        if (this.mappingCallbacks != null) {
            for (MappingCallbacks m : this.mappingCallbacks) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052212", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), ((JavaTypeMapping)((Object)m)).getMemberMetaData().getFullFieldName()}));
                }
                m.preDelete(sm);
                JavaTypeMapping mapping = (JavaTypeMapping)((Object)m);
                AbstractMemberMetaData mmd = mapping.getMemberMetaData();
                RelationType relationType = mmd.getRelationType(clr);
                if (!mmd.isDependent() || relationType != RelationType.ONE_TO_ONE_UNI && (relationType != RelationType.ONE_TO_ONE_BI || mmd.getMappedBy() != null)) continue;
                try {
                    sm.isLoaded(mmd.getAbsoluteFieldNumber());
                    Object relatedPc = sm.provideField(mmd.getAbsoluteFieldNumber());
                    boolean relatedObjectDeleted = sm.getExecutionContext().getApiAdapter().isDeleted(relatedPc);
                    if (relatedObjectDeleted) continue;
                    if (relatedObjectsToDelete == null) {
                        relatedObjectsToDelete = new HashSet<Object>();
                    }
                    relatedObjectsToDelete.add(relatedPc);
                }
                catch (Exception relatedPc) {}
            }
        }
        if (this.oneToOneNonOwnerFields != null && this.oneToOneNonOwnerFields.length > 0) {
            for (int i = 0; i < this.oneToOneNonOwnerFields.length; ++i) {
                this.updateOneToOneBidirectionalOwnerObjectForField(sm, this.oneToOneNonOwnerFields[i]);
            }
        }
        String stmt = null;
        ExecutionContext ec = sm.getExecutionContext();
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        boolean optimisticChecks = false;
        if (this.table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null) {
            stmt = this.softDeleteStmt;
        } else {
            optimisticChecks = this.versionChecks && ec.getTransaction().getOptimistic();
            stmt = optimisticChecks ? this.deleteStmtOptimistic : this.deleteStmt;
        }
        try {
            ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                boolean batch = true;
                if (storeMgr.getFlushProcess() instanceof BatchingFlushProcess) {
                    batch = ((BatchingFlushProcess)storeMgr.getFlushProcess()).batchInDeleteRequest(optimisticChecks, ec);
                } else if (optimisticChecks || !ec.getTransaction().isActive()) {
                    batch = false;
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, batch);
                try {
                    if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                        StatementMappingIndex mapIdx = this.mappingStatementIndex.getWhereDatastoreId();
                        for (int i = 0; i < mapIdx.getNumberOfParameterOccurrences(); ++i) {
                            this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, mapIdx.getParameterPositionsForOccurrence(i), sm.getInternalObjectId());
                        }
                    } else {
                        StatementClassMapping mappingDefinition = new StatementClassMapping();
                        StatementMappingIndex[] idxs = this.mappingStatementIndex.getWhereFields();
                        for (int i = 0; i < idxs.length; ++i) {
                            if (idxs[i] == null) continue;
                            mappingDefinition.addMappingForMember(i, idxs[i]);
                        }
                        sm.provideFields(this.whereFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, mappingDefinition));
                    }
                    if (this.multitenancyStatementMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false).setObject(ec, ps, this.multitenancyStatementMapping.getParameterPositionsForOccurrence(0), ec.getTenantId());
                    }
                    if (optimisticChecks) {
                        JavaTypeMapping verMapping = this.mappingStatementIndex.getWhereVersion().getMapping();
                        Object currentVersion = sm.getTransactionalVersion();
                        if (currentVersion == null) {
                            String msg = Localiser.msg((String)"052202", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), this.table});
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusException(msg);
                        }
                        StatementMappingIndex mapIdx = this.mappingStatementIndex.getWhereVersion();
                        for (int i = 0; i < mapIdx.getNumberOfParameterOccurrences(); ++i) {
                            verMapping.setObject(ec, ps, mapIdx.getParameterPositionsForOccurrence(i), currentVersion);
                        }
                    }
                    IntConsumer handler = rows -> {
                        if (rows == 0) {
                            throw new NucleusOptimisticException(Localiser.msg((String)"052203", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), "" + sm.getTransactionalVersion()}), sm.getObject());
                        }
                    };
                    sqlControl.executeStatementUpdateDeferRowCountCheckForBatching(ec, mconn, stmt, ps, !batch, optimisticChecks ? handler : null);
                    if (relatedObjectsToDelete != null && !relatedObjectsToDelete.isEmpty()) {
                        Iterator iter = relatedObjectsToDelete.iterator();
                        while (iter.hasNext()) {
                            if (batch && optimisticChecks) {
                                throw new UnsupportedOperationException("relatedObjectsToDelete after batched optimistic checks");
                            }
                            Object relatedObject = iter.next();
                            ec.deleteObjectInternal(relatedObject);
                        }
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Localiser.msg((String)"052211", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), stmt, e.getMessage()});
            throw RequestUtil.convertSqlException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOneToOneBidirectionalOwnerObjectForField(DNStateManager sm, AbstractMemberMetaData mmd) {
        if (this.softDeleteStmt != null) {
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052217", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), mmd.getFullFieldName()}));
        }
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        ExecutionContext ec = sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
        boolean checkFK = true;
        if (ec.getStringProperty(PropertyNames.PROPERTY_DELETION_POLICY).equals("JDO2")) {
            checkFK = false;
        }
        if (checkFK) {
            for (int i = 0; i < relatedMmds.length; ++i) {
                ForeignKeyMetaData relFkmd = relatedMmds[i].getForeignKeyMetaData();
                if (relFkmd == null || relFkmd.getDeleteAction() == null) continue;
                return;
            }
        }
        String fullClassName = ((AbstractClassMetaData)relatedMmds[0].getParent()).getFullClassName();
        String[] classes = (AbstractClassMetaData)relatedMmds[0].getParent() instanceof InterfaceMetaData ? storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(fullClassName, clr) : new String[]{fullClassName};
        HashSet<DatastoreClass> datastoreClasses = new HashSet<DatastoreClass>();
        for (int i = 0; i < classes.length; ++i) {
            datastoreClasses.add(storeMgr.getDatastoreClass(classes[i], clr));
        }
        for (DatastoreClass refTable : datastoreClasses) {
            int j;
            JavaTypeMapping refMapping = refTable.getMemberMapping(mmd.getMappedBy());
            if (!refMapping.isNullable()) continue;
            StringBuilder clearLinkStmt = new StringBuilder("UPDATE " + refTable.toString() + " SET ");
            for (j = 0; j < refMapping.getNumberOfColumnMappings(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(",");
                }
                clearLinkStmt.append(refMapping.getColumnMapping(j).getColumn().getIdentifier());
                clearLinkStmt.append("=NULL");
            }
            clearLinkStmt.append(" WHERE ");
            for (j = 0; j < refMapping.getNumberOfColumnMappings(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(" AND ");
                }
                clearLinkStmt.append(refMapping.getColumnMapping(j).getColumn().getIdentifier());
                clearLinkStmt.append("=?");
            }
            try {
                ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = null;
                    try {
                        ps = sqlControl.getStatementForUpdate(mconn, clearLinkStmt.toString(), false);
                        refMapping.setObject(ec, ps, MappingHelper.getMappingIndices(1, refMapping), sm.getObject());
                        sqlControl.executeStatementUpdate(ec, mconn, clearLinkStmt.toString(), ps, true);
                    }
                    finally {
                        if (ps == null) continue;
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (Exception e) {
                throw new NucleusDataStoreException("Update request failed", (Throwable)e);
            }
        }
    }

    private class DeleteMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        StringBuilder where = new StringBuilder();
        int paramIndex = 1;
        private List<Integer> whereFields = new ArrayList<Integer>();
        private List<AbstractMemberMetaData> oneToOneNonOwnerFields = new ArrayList<AbstractMemberMetaData>();
        private List<MappingCallbacks> callbackMappings = null;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;
        private boolean whereClauseConsumption = false;

        public DeleteMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = 1;
        }

        public void setWhereClauseConsumption() {
            this.whereClauseConsumption = true;
        }

        @Override
        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                DeleteRequest.this.mappingStatementIndex.setWhereFields(new StatementMappingIndex[highest]);
                DeleteRequest.this.mappingStatementIndex.setUpdateFields(new StatementMappingIndex[highest]);
                this.initialized = true;
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData mmd) {
            if (!mmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (this.whereClauseConsumption) {
                    VersionMetaData vermd = this.cmd.getVersionMetaDataForTable();
                    if (!DeleteRequest.this.table.managesClass(this.cmd.getFullClassName())) {
                        vermd = this.cmd.getBaseAbstractClassMetaData().getVersionMetaDataForClass();
                    }
                    if (vermd != null && vermd.getMemberName() != null && mmd.getName().equals(vermd.getMemberName())) {
                        StatementMappingIndex sei = new StatementMappingIndex(m);
                        DeleteRequest.this.mappingStatementIndex.setWhereVersion(sei);
                        int[] parametersIndex = new int[]{this.paramIndex++};
                        sei.addParameterOccurrence(parametersIndex);
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        this.where.append(m.getColumnMapping(0).getColumn().getIdentifier());
                        this.where.append("=");
                        this.where.append(m.getColumnMapping(0).getUpdateInputParameter());
                    } else {
                        Integer abs_field_num = mmd.getAbsoluteFieldNumber();
                        int[] parametersIndex = new int[m.getNumberOfColumnMappings()];
                        StatementMappingIndex sei = new StatementMappingIndex(m);
                        sei.addParameterOccurrence(parametersIndex);
                        DeleteRequest.this.mappingStatementIndex.getWhereFields()[mmd.getAbsoluteFieldNumber()] = sei;
                        for (int j = 0; j < parametersIndex.length; ++j) {
                            if (this.where.length() > 0) {
                                this.where.append(" AND ");
                            }
                            this.where.append(m.getColumnMapping(j).getColumn().getIdentifier());
                            if (DeleteRequest.this.nullPkFields.get(abs_field_num)) {
                                this.where.append(" IS NULL");
                                continue;
                            }
                            this.where.append("=");
                            this.where.append(m.getColumnMapping(j).getUpdateInputParameter());
                            if (!this.whereFields.contains(abs_field_num)) {
                                this.whereFields.add(abs_field_num);
                            }
                            ++this.paramIndex;
                        }
                    }
                }
                if ((m instanceof PersistableMapping || m instanceof ReferenceMapping) && m.getNumberOfColumnMappings() == 0) {
                    RelationType relationType = mmd.getRelationType(this.clr);
                    if (relationType == RelationType.ONE_TO_ONE_BI) {
                        if (mmd.getMappedBy() != null) {
                            this.oneToOneNonOwnerFields.add(mmd);
                        }
                    } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                        if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                if (this.callbackMappings == null) {
                    this.callbackMappings = new ArrayList<MappingCallbacks>();
                }
                this.callbackMappings.add((MappingCallbacks)((Object)m));
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, MappingType mappingType) {
            if (mappingType == MappingType.DATASTORE_ID) {
                if (this.where.length() > 0) {
                    this.where.append(" AND ");
                }
                this.where.append(m.getColumnMapping(0).getColumn().getIdentifier().toString());
                this.where.append("=");
                this.where.append(m.getColumnMapping(0).getUpdateInputParameter());
                StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(m);
                DeleteRequest.this.mappingStatementIndex.setWhereDatastoreId(datastoreMappingIdx);
                int[] param = new int[]{this.paramIndex++};
                datastoreMappingIdx.addParameterOccurrence(param);
            } else if (mappingType == MappingType.VERSION) {
                if (this.where.length() > 0) {
                    this.where.append(" AND ");
                }
                this.where.append(m.getColumnMapping(0).getColumn().getIdentifier());
                this.where.append("=");
                this.where.append(m.getColumnMapping(0).getUpdateInputParameter());
                StatementMappingIndex versStmtIdx = new StatementMappingIndex(m);
                DeleteRequest.this.mappingStatementIndex.setWhereVersion(versStmtIdx);
                int[] param = new int[]{this.paramIndex++};
                versStmtIdx.addParameterOccurrence(param);
            } else if (mappingType == MappingType.MULTITENANCY) {
                JavaTypeMapping tenantMapping = DeleteRequest.this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false);
                if (this.where.length() > 0) {
                    this.where.append(" AND ");
                }
                this.where.append(tenantMapping.getColumnMapping(0).getColumn().getIdentifier().toString());
                this.where.append("=");
                this.where.append(tenantMapping.getColumnMapping(0).getUpdateInputParameter());
                DeleteRequest.this.multitenancyStatementMapping = new StatementMappingIndex(tenantMapping);
                int[] param = new int[]{this.paramIndex++};
                DeleteRequest.this.multitenancyStatementMapping.addParameterOccurrence(param);
            }
        }

        @Override
        public void consumeUnmappedColumn(Column col) {
        }

        public int[] getWhereFieldNumbers() {
            int[] fieldNumbers = new int[this.whereFields.size()];
            for (int i = 0; i < this.whereFields.size(); ++i) {
                fieldNumbers[i] = this.whereFields.get(i);
            }
            return fieldNumbers;
        }

        public AbstractMemberMetaData[] getOneToOneNonOwnerFields() {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.oneToOneNonOwnerFields.size()];
            for (int i = 0; i < this.oneToOneNonOwnerFields.size(); ++i) {
                fmds[i] = this.oneToOneNonOwnerFields.get(i);
            }
            return fmds;
        }

        public List<MappingCallbacks> getMappingCallBacks() {
            return this.callbackMappings;
        }

        public String getStatement() {
            return "DELETE FROM " + DeleteRequest.this.table.toString() + " WHERE " + this.where;
        }

        public String getSoftDeleteStatement() {
            org.datanucleus.store.schema.table.Column softDeleteCol = DeleteRequest.this.table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE);
            return "UPDATE " + DeleteRequest.this.table.toString() + " SET " + softDeleteCol.getName() + "=TRUE WHERE " + this.where;
        }
    }
}

