/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.mapping.column.BlobImpl;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingPostSet;
import org.datanucleus.store.rdbms.mapping.java.BitSetMapping;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.util.Localiser;

public class OracleBitSetMapping
extends BitSetMapping {
    @Override
    public void performSetPostProcessing(DNStateManager sm) {
        Object value = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        byte[] bytes = new byte[]{};
        try {
            if (this.mmd.isSerialized()) {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            } else if (value instanceof BitSet) {
                bytes = ArrayConversionHelper.getByteArrayFromBooleanArray((boolean[])ArrayConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
            } else {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.mmd, e.getMessage()}), (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.columnMappings[0] instanceof ColumnMappingPostSet) {
            ((ColumnMappingPostSet)((Object)this.columnMappings[0])).setPostProcessing(sm, bytes);
        }
    }
}

