/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class ConcurrentFixedCache<K, V> {
    private final Function<K, V> factory;
    private volatile Map<K, V> immutable = Collections.emptyMap();

    public ConcurrentFixedCache(Function<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        V value = this.immutable.get(key);
        if (value == null) {
            HashMap<K, V> copy = new HashMap<K, V>(this.immutable);
            value = this.factory.apply(key);
            copy.put(key, value);
            this.immutable = copy;
        }
        return value;
    }
}

