/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.rbfbalance;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.rbfbalance.RouterDistCpProcedure;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.tools.fedbalance.DistCpProcedure;
import org.apache.hadoop.tools.fedbalance.FedBalanceContext;
import org.apache.hadoop.tools.fedbalance.TestDistCpProcedure;
import org.apache.hadoop.util.Time;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class TestRouterDistCpProcedure
extends TestDistCpProcedure {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static Configuration routerConf;
    private static StateStoreService stateStore;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
        ActiveNamenodeResolver membership = router.getNamenodeResolver();
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns0", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        stateStore.refreshCaches(true);
        routerConf = new Configuration();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        routerConf.setSocketAddr("dfs.federation.router.admin-address", routerSocket);
    }

    public void testDisableWrite() throws Exception {
        String mount = "/test-write";
        MountTable newEntry = MountTable.newInstance((String)mount, Collections.singletonMap("ns0", mount), (long)Time.now(), (long)Time.now());
        MountTableManager mountTable = routerContext.getAdminClient().getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        stateStore.loadCache(MountTableStoreImpl.class, true);
        URI address = routerContext.getFileSystemURI();
        DFSClient routerClient = new DFSClient(address, routerConf);
        FedBalanceContext context = new FedBalanceContext.Builder(null, null, mount, routerConf).build();
        RouterDistCpProcedure dcProcedure = new RouterDistCpProcedure();
        TestRouterDistCpProcedure.executeProcedure((DistCpProcedure)dcProcedure, (DistCpProcedure.Stage)DistCpProcedure.Stage.FINAL_DISTCP, () -> dcProcedure.disableWrite(context));
        LambdaTestUtils.intercept(RemoteException.class, (String)"is in a read only mount point", (String)"Expect readonly exception.", () -> routerClient.mkdirs(mount + "/dir", new FsPermission(16), false));
    }

    @AfterClass
    public static void tearDown() {
        cluster.stopRouter(routerContext);
    }
}

