/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.subclustercleaner;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubClusterCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SubClusterCleaner.class);
    private GPGContext gpgContext;
    private long heartbeatExpirationMillis;

    public SubClusterCleaner(Configuration conf, GPGContext gpgContext) {
        this.heartbeatExpirationMillis = conf.getTimeDuration("yarn.federation.gpg.subcluster.heartbeat.expiration-ms", YarnConfiguration.DEFAULT_GPG_SUBCLUSTER_EXPIRATION_MS, TimeUnit.MILLISECONDS);
        this.gpgContext = gpgContext;
        LOG.info("Initialized SubClusterCleaner with heartbeat expiration of {}", (Object)DurationFormatUtils.formatDurationISO((long)this.heartbeatExpirationMillis));
    }

    @Override
    public void run() {
        try {
            Date now = new Date();
            LOG.info("SubClusterCleaner at {}", (Object)now);
            Map infoMap = this.gpgContext.getStateStoreFacade().getSubClusters(false, true);
            for (Map.Entry entry : infoMap.entrySet()) {
                SubClusterInfo subClusterInfo = (SubClusterInfo)entry.getValue();
                Date lastHeartBeat = new Date(subClusterInfo.getLastHeartBeat());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking subcluster {} in state {}, last heartbeat at {}", new Object[]{subClusterInfo.getSubClusterId(), subClusterInfo.getState(), lastHeartBeat});
                }
                if (!subClusterInfo.getState().isUsable()) continue;
                long timeUntilDeregister = this.heartbeatExpirationMillis - (now.getTime() - lastHeartBeat.getTime());
                if (timeUntilDeregister < 0L) {
                    LOG.warn("Deregistering subcluster {} in state {} last heartbeat at {}", new Object[]{subClusterInfo.getSubClusterId(), subClusterInfo.getState(), new Date(subClusterInfo.getLastHeartBeat())});
                    try {
                        this.gpgContext.getStateStoreFacade().deregisterSubCluster(subClusterInfo.getSubClusterId(), SubClusterState.SC_LOST);
                    }
                    catch (Exception e) {
                        LOG.error("deregisterSubCluster failed on subcluster " + subClusterInfo.getSubClusterId(), (Throwable)e);
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Time until deregister for subcluster {}: {}", entry.getKey(), (Object)DurationFormatUtils.formatDurationISO((long)timeUntilDeregister));
            }
        }
        catch (Throwable e) {
            LOG.error("Subcluster cleaner fails: ", e);
        }
    }
}

