/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator;

import java.util.Map;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.manager.WeightedLocalityPolicyManager;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGUtils;
import org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator.GlobalPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformWeightedLocalityGlobalPolicy
extends GlobalPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(UniformWeightedLocalityGlobalPolicy.class);

    @Override
    protected FederationPolicyManager updatePolicy(String queueName, Map<SubClusterId, Map<Class, Object>> clusterInfo, FederationPolicyManager currentManager) {
        if (currentManager == null) {
            LOG.info("Creating uniform weighted policy queue {}.", (Object)queueName);
            WeightedLocalityPolicyManager manager = new WeightedLocalityPolicyManager();
            manager.setQueue(queueName);
            Map<SubClusterIdInfo, Float> policyWeights = GPGUtils.createUniformWeights(clusterInfo.keySet());
            manager.getWeightedPolicyInfo().setAMRMPolicyWeights(policyWeights);
            manager.getWeightedPolicyInfo().setRouterPolicyWeights(policyWeights);
            currentManager = manager;
        }
        if (currentManager instanceof WeightedLocalityPolicyManager) {
            LOG.info("Updating policy for queue {} to default weights.", (Object)queueName);
            WeightedLocalityPolicyManager wlpmanager = (WeightedLocalityPolicyManager)currentManager;
            Map<SubClusterIdInfo, Float> uniformWeights = GPGUtils.createUniformWeights(clusterInfo.keySet());
            wlpmanager.getWeightedPolicyInfo().setAMRMPolicyWeights(uniformWeights);
            wlpmanager.getWeightedPolicyInfo().setRouterPolicyWeights(uniformWeights);
        } else {
            LOG.info("Policy for queue {} is of type {}, expected {}", new Object[]{queueName, currentManager.getClass(), WeightedLocalityPolicyManager.class});
        }
        return currentManager;
    }
}

