/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestResponseBuffer {
    @Test
    public void testBuffer() throws IOException {
        int startSize = 8;
        String empty = "";
        ResponseBuffer buf = new ResponseBuffer(8);
        Assert.assertEquals((long)8L, (long)buf.capacity());
        this.checkBuffer(buf, "");
        buf.writeBytes("");
        this.checkBuffer(buf, "");
        String s1 = "testing123";
        buf.writeBytes(s1);
        this.checkBuffer(buf, s1);
        String s2 = "456!";
        buf.writeBytes(s2);
        this.checkBuffer(buf, s1 + s2);
        int length = buf.capacity();
        buf.reset();
        Assert.assertEquals((long)length, (long)buf.capacity());
        this.checkBuffer(buf, "");
        buf.setCapacity(8);
        Assert.assertEquals((long)8L, (long)buf.capacity());
        this.checkBuffer(buf, "");
        buf.writeBytes(s1);
        this.checkBuffer(buf, s1);
        buf.writeBytes(s2);
        this.checkBuffer(buf, s1 + s2);
    }

    private void checkBuffer(ResponseBuffer buf, String expected) throws IOException {
        int expectedLength = expected.getBytes().length;
        Assert.assertEquals((long)expectedLength, (long)buf.size());
        byte[] framed = buf.toByteArray();
        Assert.assertEquals((long)(expectedLength + 4), (long)framed.length);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(framed));
        Assert.assertEquals((long)expectedLength, (long)dis.readInt());
        Assert.assertEquals((long)expectedLength, (long)dis.available());
        byte[] payload = new byte[expectedLength];
        dis.readFully(payload);
        Assert.assertEquals((Object)expected, (Object)new String(payload));
    }
}

