/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestDataByteBuffers {
    private static final Random RAND = new Random(31L);

    private static void readJunk(DataInput in, int iter) throws IOException {
        RAND.setSeed(31L);
        block9: for (int i = 0; i < iter; ++i) {
            switch (RAND.nextInt(7)) {
                case 0: {
                    Assert.assertEquals((long)((byte)(RAND.nextInt() & 0xFF)), (long)in.readByte());
                    continue block9;
                }
                case 1: {
                    Assert.assertEquals((long)((short)(RAND.nextInt() & 0xFFFF)), (long)in.readShort());
                    continue block9;
                }
                case 2: {
                    Assert.assertEquals((long)RAND.nextInt(), (long)in.readInt());
                    continue block9;
                }
                case 3: {
                    Assert.assertEquals((long)RAND.nextLong(), (long)in.readLong());
                    continue block9;
                }
                case 4: {
                    Assert.assertEquals((long)Double.doubleToLongBits(RAND.nextDouble()), (long)Double.doubleToLongBits(in.readDouble()));
                    continue block9;
                }
                case 5: {
                    Assert.assertEquals((long)Float.floatToIntBits(RAND.nextFloat()), (long)Float.floatToIntBits(in.readFloat()));
                    continue block9;
                }
                case 6: {
                    int len = RAND.nextInt(1024);
                    byte[] vb = new byte[len];
                    RAND.nextBytes(vb);
                    byte[] b = new byte[len];
                    in.readFully(b, 0, len);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    continue block9;
                }
                default: {
                    throw new IOException();
                }
            }
        }
    }

    private static void writeJunk(DataOutput out, int iter) throws IOException {
        RAND.setSeed(31L);
        block9: for (int i = 0; i < iter; ++i) {
            switch (RAND.nextInt(7)) {
                case 0: {
                    out.writeByte(RAND.nextInt());
                    continue block9;
                }
                case 1: {
                    out.writeShort((short)(RAND.nextInt() & 0xFFFF));
                    continue block9;
                }
                case 2: {
                    out.writeInt(RAND.nextInt());
                    continue block9;
                }
                case 3: {
                    out.writeLong(RAND.nextLong());
                    continue block9;
                }
                case 4: {
                    out.writeDouble(RAND.nextDouble());
                    continue block9;
                }
                case 5: {
                    out.writeFloat(RAND.nextFloat());
                    continue block9;
                }
                case 6: {
                    byte[] b = new byte[RAND.nextInt(1024)];
                    RAND.nextBytes(b);
                    out.write(b);
                    continue block9;
                }
                default: {
                    throw new IOException();
                }
            }
        }
    }

    @Test
    public void testBaseBuffers() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        TestDataByteBuffers.writeJunk((DataOutput)dob, 1000);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        TestDataByteBuffers.readJunk((DataInput)dib, 1000);
        dob.reset();
        TestDataByteBuffers.writeJunk((DataOutput)dob, 1000);
        dib.reset(dob.getData(), 0, dob.getLength());
        TestDataByteBuffers.readJunk((DataInput)dib, 1000);
    }

    @Test
    public void testDataInputByteBufferCompatibility() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        TestDataByteBuffers.writeJunk((DataOutput)dob, 1000);
        ByteBuffer buf = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        DataInputByteBuffer dib = new DataInputByteBuffer();
        dib.reset(new ByteBuffer[]{buf});
        TestDataByteBuffers.readJunk((DataInput)dib, 1000);
    }
}

