/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.shell.Concat;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestFsShellConcat
extends AbstractHadoopTestBase {
    private static Configuration conf;
    private static FsShell shell;
    private static LocalFileSystem lfs;
    private static Path testRootDir;
    private static Path dstPath;

    @Before
    public void before() throws IOException {
        conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        testRootDir = lfs.makeQualified(new Path(GenericTestUtils.getTempPath("testFsShellCopy")));
        lfs.delete(testRootDir, true);
        lfs.mkdirs(testRootDir);
        lfs.setWorkingDirectory(testRootDir);
        dstPath = new Path(testRootDir, "dstFile");
        lfs.create(dstPath).close();
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            FSDataOutputStream out = lfs.create(new Path(testRootDir, String.format("file-%02d", i)));
            out.write(random.nextInt());
            out.close();
        }
    }

    @Test
    public void testConcat() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < 10; ++i) {
            try (FSDataInputStream in = lfs.open(new Path(testRootDir, String.format("file-%02d", i)));){
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
                continue;
            }
        }
        byte[] expectContent = out.toByteArray();
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Path target = (Path)args[0];
            Path[] src = (Path[])args[1];
            this.mockConcat(target, src);
            return null;
        }).when((Object)mockFs)).concat((Path)ArgumentMatchers.any(Path.class), (Path[])ArgumentMatchers.any(Path[].class));
        Concat.setTestFs((FileSystem)mockFs);
        this.shellRun(0, "-concat", dstPath.toString(), testRootDir + "/file-*");
        ContractTestUtils.assertPathExists((FileSystem)lfs, "The target file doesn't exist.", dstPath);
        Assertions.assertThat((int)lfs.listStatus(testRootDir).length).isEqualTo(1);
        Assert.assertEquals((long)expectContent.length, (long)lfs.getFileStatus(dstPath).getLen());
        out = new ByteArrayOutputStream();
        try (FSDataInputStream in = lfs.open(dstPath);){
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        }
        byte[] concatedContent = out.toByteArray();
        Assert.assertEquals((long)expectContent.length, (long)concatedContent.length);
        ContractTestUtils.compareByteArrays(expectContent, concatedContent, expectContent.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsupportedFs() throws Exception {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedOperationException("Mock unsupported exception.")}).when((Object)mockFs)).concat((Path)ArgumentMatchers.any(Path.class), (Path[])ArgumentMatchers.any(Path[].class));
        ((FileSystem)Mockito.doAnswer(invocationOnMock -> new URI("mockfs:///")).when((Object)mockFs)).getUri();
        Concat.setTestFs((FileSystem)mockFs);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream oldErr = System.err;
        System.setErr(new PrintStream(err));
        try {
            this.shellRun(1, "-concat", dstPath.toString(), testRootDir + "/file-*");
        }
        finally {
            System.setErr(oldErr);
        }
        System.err.print(err.toString());
        String expectedErrMsg = "Dest filesystem 'mockfs' doesn't support concat";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)err.toString().contains(expectedErrMsg)).withFailMessage("The err message should contain \"" + expectedErrMsg + "\" message.", new Object[0])).isTrue();
    }

    private void shellRun(int n, String ... args) {
        Assert.assertEquals((long)n, (long)shell.run(args));
    }

    private void mockConcat(Path target, Path[] srcArray) throws IOException {
        Path tmp = new Path(target.getParent(), target.getName() + ".bak");
        lfs.rename(target, tmp);
        try (FSDataOutputStream out = lfs.create(target);){
            try (FSDataInputStream in = lfs.open(tmp);){
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
            }
            lfs.delete(tmp, true);
            for (int i = 0; i < srcArray.length; ++i) {
                try (FSDataInputStream iin = lfs.open(srcArray[i]);){
                    IOUtils.copyBytes((InputStream)iin, (OutputStream)out, (int)1024);
                }
                lfs.delete(srcArray[i], true);
            }
        }
    }
}

