/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.common.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.hadoop.yarn.api.records.Resource;

public class ResourceSerDe
implements JsonSerializer<Resource>,
JsonDeserializer<Resource> {
    private static final String KEY1 = "memory";
    private static final String KEY2 = "vcores";

    public final JsonElement serialize(Resource resource, Type type, JsonSerializationContext context) {
        JsonObject jo = new JsonObject();
        jo.addProperty(KEY1, (Number)resource.getMemorySize());
        jo.addProperty(KEY2, (Number)resource.getVirtualCores());
        return jo;
    }

    public final Resource deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = json.getAsJsonObject();
        long mem = jo.getAsJsonPrimitive(KEY1).getAsLong();
        int vcore = jo.getAsJsonPrimitive(KEY2).getAsInt();
        Resource resource = Resource.newInstance((long)mem, (int)vcore);
        return resource;
    }
}

