/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Identification {
    static final String OS_ID;
    static final String CPU_ID;
    static final String ARCH_NAME;
    static final String[] NATIVE_SEARCH_PATHS;
    static final Pattern OS_RELEASE_VERSION_ID_PATTERN;
    static final Pattern DISTRIBUTION_RELEASE_VERSION_PATTERN;
    static final Pattern MAC_VERSION_PATTERN;
    static final String OS_RELEASE_FILE = "/etc/os-release";
    static final String FEDORA_RELEASE_FILE = "/etc/fedora-release";
    static final String REDHAT_RELEASE_FILE = "/etc/redhat-release";
    static final String ID = "ID=";
    static final String VERSION_ID = "VERSION_ID=";
    static final String RHEL = "rhel";
    static final String FEDORA = "fedora";

    Identification() {
    }

    /*
     * Exception decompiling
     */
    private static String getLinuxOSVersionFromOSReleaseFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String getLinuxOSVersionFromDistributionFile(String distributionFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getLinuxOSVersion() {
        String osVersion = Identification.getLinuxOSVersionFromOSReleaseFile();
        if (osVersion == null && (osVersion = Identification.getLinuxOSVersionFromDistributionFile(FEDORA_RELEASE_FILE)) == null) {
            osVersion = Identification.getLinuxOSVersionFromDistributionFile(REDHAT_RELEASE_FILE);
        }
        return osVersion;
    }

    static {
        OS_RELEASE_VERSION_ID_PATTERN = Pattern.compile("([0-9]+).*");
        DISTRIBUTION_RELEASE_VERSION_PATTERN = Pattern.compile(".*\\s([0-9]+).*");
        MAC_VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+)\\.[0-9]+");
        Object[] strings = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                boolean knownOs = true;
                String osVersion = null;
                String osName = System.getProperty("jboss.modules.os-name");
                if (osName == null) {
                    String sysOs = System.getProperty("os.name");
                    if (sysOs == null) {
                        osName = "unknown";
                        knownOs = false;
                    } else if ((sysOs = sysOs.toUpperCase(Locale.US)).startsWith("LINUX")) {
                        osName = "linux";
                        osVersion = Identification.getLinuxOSVersion();
                    } else if (sysOs.startsWith("MAC OS")) {
                        osName = "macosx";
                        String sysVersion = System.getProperty("os.version");
                        Matcher m = MAC_VERSION_PATTERN.matcher(sysVersion);
                        if (m.matches()) {
                            osVersion = m.group(1);
                        }
                    } else if (sysOs.startsWith("WINDOWS")) {
                        osName = "win";
                    } else if (sysOs.startsWith("OS/2")) {
                        osName = "os2";
                    } else if (sysOs.startsWith("SOLARIS") || sysOs.startsWith("SUNOS")) {
                        osName = "solaris";
                    } else if (sysOs.startsWith("MPE/IX")) {
                        osName = "mpeix";
                    } else if (sysOs.startsWith("HP-UX")) {
                        osName = "hpux";
                    } else if (sysOs.startsWith("AIX")) {
                        osName = "aix";
                    } else if (sysOs.startsWith("OS/390")) {
                        osName = "os390";
                    } else if (sysOs.startsWith("OS/400")) {
                        osName = "os400";
                    } else if (sysOs.startsWith("FREEBSD")) {
                        osName = "freebsd";
                    } else if (sysOs.startsWith("OPENBSD")) {
                        osName = "openbsd";
                    } else if (sysOs.startsWith("NETBSD")) {
                        osName = "netbsd";
                    } else if (sysOs.startsWith("IRIX")) {
                        osName = "irix";
                    } else if (sysOs.startsWith("DIGITAL UNIX")) {
                        osName = "digitalunix";
                    } else if (sysOs.startsWith("OSF1")) {
                        osName = "osf1";
                    } else if (sysOs.startsWith("OPENVMS")) {
                        osName = "openvms";
                    } else if (sysOs.startsWith("IOS")) {
                        osName = "iOS";
                    } else {
                        osName = "unknown";
                        knownOs = false;
                    }
                }
                boolean knownCpu = true;
                ArrayList<String> cpuNames = new ArrayList<String>();
                String cpuName = System.getProperty("jboss.modules.cpu-name");
                if (cpuName == null) {
                    String sysArch = System.getProperty("os.arch");
                    if (sysArch == null) {
                        cpuName = "unknown";
                        knownCpu = false;
                    } else {
                        boolean hasEndian = false;
                        boolean hasHardFloatABI = false;
                        if ((sysArch = sysArch.toUpperCase(Locale.US)).startsWith("SPARCV9") || sysArch.startsWith("SPARC64")) {
                            cpuName = "sparcv9";
                        } else if (sysArch.startsWith("SPARC")) {
                            cpuName = "sparc";
                        } else if (sysArch.startsWith("X86_64") || sysArch.startsWith("AMD64")) {
                            cpuName = "x86_64";
                        } else if (sysArch.startsWith("I386")) {
                            cpuName = "i386";
                        } else if (sysArch.startsWith("I486")) {
                            cpuName = "i486";
                        } else if (sysArch.startsWith("I586")) {
                            cpuName = "i586";
                        } else if (sysArch.startsWith("I686") || sysArch.startsWith("X86") || sysArch.contains("IA32")) {
                            cpuName = "i686";
                        } else if (sysArch.startsWith("X32")) {
                            cpuName = "x32";
                        } else if (sysArch.startsWith("PPC64LE")) {
                            cpuName = "ppc64le";
                        } else if (sysArch.startsWith("PPC64")) {
                            cpuName = "ppc64";
                        } else if (sysArch.startsWith("PPC") || sysArch.startsWith("POWER")) {
                            cpuName = "ppc";
                        } else if (sysArch.startsWith("ARMV7A") || sysArch.contains("AARCH32")) {
                            hasEndian = true;
                            hasHardFloatABI = true;
                            cpuName = "armv7a";
                        } else if (sysArch.startsWith("AARCH64") || sysArch.startsWith("ARM64") || sysArch.startsWith("ARMV8") || sysArch.startsWith("PXA9") || sysArch.startsWith("PXA10")) {
                            hasEndian = true;
                            cpuName = "aarch64";
                        } else if (sysArch.startsWith("PXA27")) {
                            hasEndian = true;
                            cpuName = "armv5t-iwmmx";
                        } else if (sysArch.startsWith("PXA3")) {
                            hasEndian = true;
                            cpuName = "armv5t-iwmmx2";
                        } else if (sysArch.startsWith("ARMV4T") || sysArch.startsWith("EP93")) {
                            hasEndian = true;
                            cpuName = "armv4t";
                        } else if (sysArch.startsWith("ARMV4") || sysArch.startsWith("EP73")) {
                            hasEndian = true;
                            cpuName = "armv4";
                        } else if (sysArch.startsWith("ARMV5T") || sysArch.startsWith("PXA") || sysArch.startsWith("IXC") || sysArch.startsWith("IOP") || sysArch.startsWith("IXP") || sysArch.startsWith("CE")) {
                            hasEndian = true;
                            String isaList = System.getProperty("sun.arch.isalist");
                            cpuName = isaList != null ? (isaList.toUpperCase(Locale.US).contains("MMX2") ? "armv5t-iwmmx2" : (isaList.toUpperCase(Locale.US).contains("MMX") ? "armv5t-iwmmx" : "armv5t")) : "armv5t";
                        } else if (sysArch.startsWith("ARMV5")) {
                            hasEndian = true;
                            cpuName = "armv5";
                        } else if (sysArch.startsWith("ARMV6")) {
                            hasEndian = true;
                            hasHardFloatABI = true;
                            cpuName = "armv6";
                        } else if (sysArch.startsWith("PA_RISC2.0W")) {
                            cpuName = "parisc64";
                        } else if (sysArch.startsWith("PA_RISC") || sysArch.startsWith("PA-RISC")) {
                            cpuName = "parisc";
                        } else if (sysArch.startsWith("IA64")) {
                            cpuName = sysArch.toLowerCase(Locale.US);
                        } else if (sysArch.startsWith("ALPHA")) {
                            cpuName = "alpha";
                        } else if (sysArch.startsWith("MIPS")) {
                            cpuName = "mips";
                        } else if (sysArch.startsWith("S390X")) {
                            cpuName = "s390x";
                        } else {
                            knownCpu = false;
                            cpuName = "unknown";
                        }
                        boolean be = false;
                        boolean hf = false;
                        if (knownCpu && hasEndian && "big".equals(System.getProperty("sun.cpu.endian", "little"))) {
                            be = true;
                        }
                        if (knownCpu && hasHardFloatABI) {
                            String archAbi = System.getProperty("sun.arch.abi");
                            if (archAbi != null) {
                                if (archAbi.toUpperCase(Locale.US).contains("HF")) {
                                    hf = true;
                                }
                            } else {
                                String libPath = System.getProperty("java.library.path");
                                if (libPath != null && libPath.toUpperCase(Locale.US).contains("GNUEABIHF")) {
                                    hf = true;
                                }
                            }
                            if (hf) {
                                cpuName = cpuName + "-hf";
                            }
                        }
                        if (knownCpu) {
                            switch (cpuName) {
                                case "i686": {
                                    cpuNames.add("i686");
                                }
                                case "i586": {
                                    cpuNames.add("i586");
                                }
                                case "i486": {
                                    cpuNames.add("i486");
                                }
                                case "i386": {
                                    cpuNames.add("i386");
                                    break;
                                }
                                case "armv7a": {
                                    cpuNames.add("armv7a");
                                    if (hf) break;
                                }
                                case "armv6": {
                                    cpuNames.add("armv6");
                                    if (hf) break;
                                }
                                case "armv5t": {
                                    cpuNames.add("armv5t");
                                }
                                case "armv5": {
                                    cpuNames.add("armv5");
                                }
                                case "armv4t": {
                                    cpuNames.add("armv4t");
                                }
                                case "armv4": {
                                    cpuNames.add("armv4");
                                    break;
                                }
                                case "armv5t-iwmmx2": {
                                    cpuNames.add("armv5t-iwmmx2");
                                }
                                case "armv5t-iwmmx": {
                                    cpuNames.add("armv5t-iwmmx");
                                    cpuNames.add("armv5t");
                                    cpuNames.add("armv5");
                                    cpuNames.add("armv4t");
                                    cpuNames.add("armv4");
                                    break;
                                }
                                default: {
                                    cpuNames.add(cpuName);
                                }
                            }
                            if (hf || be) {
                                for (int i = 0; i < cpuNames.size(); ++i) {
                                    String name = (String)cpuNames.get(i);
                                    if (be) {
                                        name = name + "-be";
                                    }
                                    if (hf) {
                                        name = name + "-hf";
                                    }
                                    cpuNames.set(i, name);
                                }
                            }
                            cpuName = (String)cpuNames.get(0);
                        }
                    }
                }
                int cpuCount = cpuNames.size();
                int searchPathsSize = osVersion != null ? cpuCount * 2 : cpuCount;
                String[] searchPaths = new String[searchPathsSize];
                if (knownOs && knownCpu) {
                    String osNameAndVersion = osVersion != null ? osName + "-" + osVersion : osName;
                    for (int i = 0; i < cpuCount; ++i) {
                        String name = (String)cpuNames.get(i);
                        searchPaths[i] = osNameAndVersion + "-" + name;
                    }
                    if (osVersion != null) {
                        int j = cpuCount;
                        for (int i = 0; i < cpuCount; ++i) {
                            String name = (String)cpuNames.get(i);
                            searchPaths[j++] = osName + "-" + name;
                        }
                    }
                } else {
                    searchPaths = new String[]{};
                }
                return new Object[]{osName, cpuName, osName + "-" + cpuName, searchPaths};
            }
        });
        OS_ID = strings[0].toString();
        CPU_ID = strings[1].toString();
        ARCH_NAME = strings[2].toString();
        NATIVE_SEARCH_PATHS = (String[])strings[3];
    }
}

