/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.AzureADAuthenticator;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenBasedTokenProvider
extends AccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger((String)"com.microsoft.azure.datalake.store.oauth2.RefreshTokenBasedTokenProvider");
    private final String clientId;
    private final String refreshToken;

    public RefreshTokenBasedTokenProvider(String refreshToken) {
        this.clientId = null;
        this.refreshToken = refreshToken;
    }

    public RefreshTokenBasedTokenProvider(String clientId, String refreshToken) {
        this.clientId = clientId;
        this.refreshToken = refreshToken;
    }

    public RefreshTokenBasedTokenProvider(String clientId, RefreshTokenInfo refreshToken) {
        this.clientId = clientId;
        this.refreshToken = refreshToken.refreshToken;
        if (refreshToken.accessToken != null && !refreshToken.accessToken.equals("") && refreshToken.accessTokenExpiry != null) {
            this.token = new AzureADToken();
            this.token.accessToken = refreshToken.accessToken;
            this.token.expiry = refreshToken.accessTokenExpiry;
        }
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        log.debug("AADToken: refreshing refresh-token based token");
        return AzureADAuthenticator.getTokenUsingRefreshToken(this.clientId, this.refreshToken);
    }
}

