/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBase170CompatibilityProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;

@InterfaceAudience.Private
public final class DeprecatedTableDescriptor {
    private HTableDescriptor hTableDescriptor;
    private ZooKeeperProtos.Table tableState;

    private DeprecatedTableDescriptor(HTableDescriptor hTableDescriptor, ZooKeeperProtos.Table tableState) {
        this.hTableDescriptor = hTableDescriptor;
        this.tableState = tableState;
    }

    public HTableDescriptor getHTableDescriptor() {
        return this.hTableDescriptor;
    }

    public ZooKeeperProtos.Table getTableState() {
        return this.tableState;
    }

    public static DeprecatedTableDescriptor parseFrom(byte[] bytes) throws DeserializationException {
        HBase170CompatibilityProtos.TableDescriptor ts;
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("Expected PB encoded TableDescriptor");
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBase170CompatibilityProtos.TableDescriptor.Builder builder = HBase170CompatibilityProtos.TableDescriptor.newBuilder();
        try {
            ts = ((HBase170CompatibilityProtos.TableDescriptor.Builder)builder.mergeFrom(bytes, pblen, bytes.length - pblen)).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return DeprecatedTableDescriptor.convert(ts);
    }

    private static DeprecatedTableDescriptor convert(HBase170CompatibilityProtos.TableDescriptor proto) {
        HTableDescriptor hTableDescriptor = HTableDescriptor.convert(proto.getSchema());
        ZooKeeperProtos.Table.State state = ZooKeeperProtos.Table.State.valueOf((int)proto.getState().getNumber());
        ZooKeeperProtos.Table tableState = ZooKeeperProtos.Table.newBuilder().setState(state).build();
        return new DeprecatedTableDescriptor(hTableDescriptor, tableState);
    }
}

