/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.io.VersionedWritable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClusterStatus
extends VersionedWritable {
    private static final byte VERSION = 2;
    private String hbaseVersion;
    private Map<ServerName, ServerLoad> liveServers;
    private Collection<ServerName> deadServers;
    private ServerName master;
    private Collection<ServerName> backupMasters;
    private Set<RegionState> intransition;
    private String clusterId;
    private String[] masterCoprocessors;
    private Boolean balancerOn;

    @Deprecated
    public ClusterStatus() {
    }

    @Deprecated
    public ClusterStatus(String hbaseVersion, String clusterid, List<ServerName> deadServers, ServerName master) {
        this(hbaseVersion, clusterid, new HashMap<ServerName, ServerLoad>(), deadServers, master, new ArrayList<ServerName>(), new HashSet<RegionState>(), new String[0], null);
    }

    @Deprecated
    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, Map<String, RegionState> rit, String[] masterCoprocessors, Boolean balancerOn) {
        this(hbaseVersion, clusterid, servers, deadServers, master, backupMasters, Sets.newHashSet(rit.values()), masterCoprocessors, balancerOn);
    }

    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, Set<RegionState> rit, String[] masterCoprocessors, Boolean balancerOn) {
        this.hbaseVersion = hbaseVersion;
        this.liveServers = servers;
        this.deadServers = deadServers;
        this.master = master;
        this.backupMasters = backupMasters;
        this.intransition = rit;
        this.clusterId = clusterid;
        this.masterCoprocessors = masterCoprocessors;
        this.balancerOn = balancerOn;
    }

    public Collection<ServerName> getDeadServerNames() {
        if (this.deadServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServersSize() {
        return this.liveServers != null ? this.liveServers.size() : 0;
    }

    public int getDeadServers() {
        return this.deadServers != null ? this.deadServers.size() : 0;
    }

    public Map<ServerName, ServerLoad> getLiveServersLoad() {
        return Collections.unmodifiableMap(this.liveServers);
    }

    public double getAverageLoad() {
        int load = this.getRegionsCount();
        return (double)load / (double)this.getServersSize();
    }

    public int getRegionsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count += e.getValue().getNumberOfRegions();
            }
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count = (int)((long)count + e.getValue().getNumberOfRequests());
            }
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        ClusterStatus other = (ClusterStatus)((Object)o);
        return Objects.equal((Object)this.getHBaseVersion(), (Object)other.getHBaseVersion()) && Objects.equal(this.liveServers, other.liveServers) && this.getDeadServerNames().containsAll(other.getDeadServerNames()) && Arrays.equals(this.getMasterCoprocessors(), other.getMasterCoprocessors()) && Objects.equal((Object)this.getMaster(), (Object)other.getMaster()) && this.getBackupMasters().containsAll(other.getBackupMasters()) && Objects.equal((Object)this.getClusterId(), (Object)other.getClusterId());
    }

    public int hashCode() {
        return 2 + this.hbaseVersion.hashCode() + this.liveServers.hashCode() + this.deadServers.hashCode() + this.master.hashCode() + this.backupMasters.hashCode();
    }

    public byte getVersion() {
        return 2;
    }

    @Deprecated
    public Collection<ServerName> getServerInfo() {
        return this.getServers();
    }

    public Collection<ServerName> getServers() {
        if (this.liveServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.liveServers.keySet());
    }

    public ServerName getMaster() {
        return this.master;
    }

    public int getBackupMastersSize() {
        return this.backupMasters != null ? this.backupMasters.size() : 0;
    }

    public Collection<ServerName> getBackupMasters() {
        if (this.backupMasters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.backupMasters);
    }

    public ServerLoad getLoad(ServerName sn) {
        return this.liveServers != null ? this.liveServers.get(sn) : null;
    }

    @InterfaceAudience.Private
    public Set<RegionState> getRegionsInTransition() {
        if (this.intransition == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.intransition);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String[] getMasterCoprocessors() {
        return this.masterCoprocessors;
    }

    public long getLastMajorCompactionTsForTable(TableName table) {
        long result = Long.MAX_VALUE;
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            for (RegionLoad rl : load.getRegionsLoad().values()) {
                if (!table.equals((Object)HRegionInfo.getTable(rl.getName()))) continue;
                result = Math.min(result, rl.getLastMajorCompactionTs());
            }
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    public long getLastMajorCompactionTsForRegion(byte[] region) {
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            RegionLoad rl = load.getRegionsLoad().get(region);
            if (rl == null) continue;
            return rl.getLastMajorCompactionTs();
        }
        return 0L;
    }

    public boolean isBalancerOn() {
        return this.balancerOn != null && this.balancerOn != false;
    }

    public Boolean getBalancerOn() {
        return this.balancerOn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Master: " + this.master);
        int backupMastersSize = this.getBackupMastersSize();
        sb.append("\nNumber of backup masters: " + backupMastersSize);
        if (backupMastersSize > 0) {
            for (ServerName serverName : this.backupMasters) {
                sb.append("\n  " + serverName);
            }
        }
        int serversSize = this.getServersSize();
        sb.append("\nNumber of live region servers: " + serversSize);
        if (serversSize > 0) {
            for (ServerName serverName : this.liveServers.keySet()) {
                sb.append("\n  " + serverName.getServerName());
            }
        }
        int deadServerSize = this.getDeadServers();
        sb.append("\nNumber of dead region servers: " + deadServerSize);
        if (deadServerSize > 0) {
            for (ServerName serverName : this.deadServers) {
                sb.append("\n  " + serverName);
            }
        }
        sb.append("\nAverage load: " + this.getAverageLoad());
        sb.append("\nNumber of requests: " + this.getRequestsCount());
        sb.append("\nNumber of regions: " + this.getRegionsCount());
        int ritSize = this.intransition != null ? this.intransition.size() : 0;
        sb.append("\nNumber of regions in transition: " + ritSize);
        if (ritSize > 0) {
            for (RegionState state : this.intransition) {
                sb.append("\n  " + state.toDescriptiveString());
            }
        }
        return sb.toString();
    }

    @Deprecated
    public ClusterStatusProtos.ClusterStatus convert() {
        ClusterStatusProtos.ClusterStatus.Builder builder = ClusterStatusProtos.ClusterStatus.newBuilder();
        builder.setHbaseVersion(FSProtos.HBaseVersionFileContent.newBuilder().setVersion(this.getHBaseVersion()));
        if (this.liveServers != null) {
            for (Map.Entry entry : this.liveServers.entrySet()) {
                ClusterStatusProtos.LiveServerInfo.Builder lsi = ClusterStatusProtos.LiveServerInfo.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)entry.getKey()));
                lsi.setServerLoad(((ServerLoad)entry.getValue()).obtainServerLoadPB());
                builder.addLiveServers(lsi.build());
            }
        }
        if (this.deadServers != null) {
            for (ServerName serverName : this.deadServers) {
                builder.addDeadServers(ProtobufUtil.toServerName(serverName));
            }
        }
        if (this.intransition != null) {
            for (RegionState regionState : this.getRegionsInTransition()) {
                ClusterStatusProtos.RegionState rs = regionState.convert();
                HBaseProtos.RegionSpecifier.Builder spec = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
                spec.setValue(ByteStringer.wrap((byte[])regionState.getRegion().getRegionName()));
                ClusterStatusProtos.RegionInTransition pbRIT = ClusterStatusProtos.RegionInTransition.newBuilder().setSpec(spec.build()).setRegionState(rs).build();
                builder.addRegionsInTransition(pbRIT);
            }
        }
        if (this.clusterId != null) {
            builder.setClusterId(new ClusterId(this.clusterId).convert());
        }
        if (this.masterCoprocessors != null) {
            for (String coprocessor : this.masterCoprocessors) {
                builder.addMasterCoprocessors(HBaseProtos.Coprocessor.newBuilder().setName(coprocessor));
            }
        }
        if (this.master != null) {
            builder.setMaster(ProtobufUtil.toServerName(this.getMaster()));
        }
        if (this.backupMasters != null) {
            for (ServerName serverName : this.backupMasters) {
                builder.addBackupMasters(ProtobufUtil.toServerName(serverName));
            }
        }
        if (this.balancerOn != null) {
            builder.setBalancerOn(this.balancerOn.booleanValue());
        }
        return builder.build();
    }

    @Deprecated
    public static ClusterStatus convert(ClusterStatusProtos.ClusterStatus proto) {
        HashMap<ServerName, ServerLoad> servers = null;
        if (!proto.getLiveServersList().isEmpty()) {
            servers = new HashMap<ServerName, ServerLoad>(proto.getLiveServersList().size());
            for (ClusterStatusProtos.LiveServerInfo lsi : proto.getLiveServersList()) {
                servers.put(ProtobufUtil.toServerName(lsi.getServer()), new ServerLoad(lsi.getServerLoad()));
            }
        }
        ArrayList<ServerName> deadServers = null;
        if (!proto.getDeadServersList().isEmpty()) {
            deadServers = new ArrayList<ServerName>(proto.getDeadServersList().size());
            for (HBaseProtos.ServerName sn : proto.getDeadServersList()) {
                deadServers.add(ProtobufUtil.toServerName(sn));
            }
        }
        ArrayList<ServerName> backupMasters = null;
        if (!proto.getBackupMastersList().isEmpty()) {
            backupMasters = new ArrayList<ServerName>(proto.getBackupMastersList().size());
            for (HBaseProtos.ServerName sn : proto.getBackupMastersList()) {
                backupMasters.add(ProtobufUtil.toServerName(sn));
            }
        }
        HashSet<RegionState> rit = null;
        if (!proto.getRegionsInTransitionList().isEmpty()) {
            rit = new HashSet<RegionState>(proto.getRegionsInTransitionList().size());
            for (ClusterStatusProtos.RegionInTransition region : proto.getRegionsInTransitionList()) {
                RegionState value = RegionState.convert(region.getRegionState());
                rit.add(value);
            }
        }
        String[] masterCoprocessors = null;
        if (!proto.getMasterCoprocessorsList().isEmpty()) {
            int numMasterCoprocessors = proto.getMasterCoprocessorsCount();
            masterCoprocessors = new String[numMasterCoprocessors];
            for (int i = 0; i < numMasterCoprocessors; ++i) {
                masterCoprocessors[i] = proto.getMasterCoprocessors(i).getName();
            }
        }
        return new ClusterStatus(proto.getHbaseVersion().getVersion(), ClusterId.convert(proto.getClusterId()).toString(), servers, deadServers, ProtobufUtil.toServerName(proto.getMaster()), backupMasters, rit, masterCoprocessors, (Boolean)proto.getBalancerOn());
    }
}

