/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.Comparator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;

class DiffInfo {
    static final Comparator<DiffInfo> sourceComparator = new Comparator<DiffInfo>(){

        @Override
        public int compare(DiffInfo d1, DiffInfo d2) {
            return d2.source.compareTo(d1.source);
        }
    };
    static final Comparator<DiffInfo> targetComparator = new Comparator<DiffInfo>(){

        @Override
        public int compare(DiffInfo d1, DiffInfo d2) {
            return d1.target == null ? (d2.target == null ? 0 : -1) : (d2.target == null ? 1 : d1.target.compareTo(d2.target));
        }
    };
    private Path source;
    private Path target;
    private SnapshotDiffReport.DiffType type;
    private Path tmp;

    DiffInfo(Path source, Path target, SnapshotDiffReport.DiffType type) {
        assert (source != null);
        this.source = source;
        this.target = target;
        this.type = type;
    }

    void setSource(Path source) {
        this.source = source;
    }

    Path getSource() {
        return this.source;
    }

    void setTarget(Path target) {
        this.target = target;
    }

    Path getTarget() {
        return this.target;
    }

    public void setType(SnapshotDiffReport.DiffType type) {
        this.type = type;
    }

    public SnapshotDiffReport.DiffType getType() {
        return this.type;
    }

    void setTmp(Path tmp) {
        this.tmp = tmp;
    }

    Path getTmp() {
        return this.tmp;
    }

    public String toString() {
        return this.type + ": src=" + String.valueOf(this.source) + " tgt=" + String.valueOf(this.target) + " tmp=" + String.valueOf(this.tmp);
    }
}

