/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public final class RationalNumber
extends Number
implements Scalar<RationalNumber>,
NumberContext.Enforceable<RationalNumber> {
    public static final Scalar.Factory<RationalNumber> FACTORY = new Scalar.Factory<RationalNumber>(){

        @Override
        public RationalNumber cast(double value) {
            return RationalNumber.valueOf(value);
        }

        @Override
        public RationalNumber cast(Number number) {
            return RationalNumber.valueOf(number);
        }

        public RationalNumber convert(double value) {
            return RationalNumber.valueOf(value);
        }

        public RationalNumber convert(Number number) {
            return RationalNumber.valueOf(number);
        }

        public RationalNumber one() {
            return ONE;
        }

        public RationalNumber zero() {
            return ZERO;
        }
    };
    public static final RationalNumber NaN = new RationalNumber(BigInteger.ZERO, BigInteger.ZERO);
    public static final RationalNumber NEG = new RationalNumber(BigInteger.ONE.negate(), BigInteger.ONE);
    public static final RationalNumber NEGATIVE_INFINITY = new RationalNumber(BigInteger.ONE.negate(), BigInteger.ZERO);
    public static final RationalNumber ONE = new RationalNumber(BigInteger.ONE, BigInteger.ONE);
    public static final RationalNumber POSITIVE_INFINITY = new RationalNumber(BigInteger.ONE, BigInteger.ZERO);
    public static final RationalNumber TWO = new RationalNumber(BigInteger.ONE.add(BigInteger.ONE), BigInteger.ONE);
    public static final RationalNumber ZERO = new RationalNumber(BigInteger.ZERO, BigInteger.ONE);
    private static final String DIVIDE = " / ";
    private static final String LEFT = "(";
    private static final String RIGHT = ")";
    private transient BigDecimal myDecimal = null;
    private final BigInteger myDenominator;
    private final BigInteger myNumerator;

    public static BigInteger gcd(BigInteger value1, BigInteger value2) {
        return value1.gcd(value2);
    }

    public static int gcd(int value1, int value2) {
        int retVal = 1;
        value1 = Math.abs(value1);
        value2 = Math.abs(value2);
        int tmpMax = Math.max(value1, value2);
        int tmpMin = Math.min(value1, value2);
        while (tmpMin != 0) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static long gcd(long value1, long value2) {
        long retVal = 1L;
        value1 = Math.abs(value1);
        value2 = Math.abs(value2);
        long tmpMax = Math.max(value1, value2);
        long tmpMin = Math.min(value1, value2);
        while (tmpMin != 0L) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static boolean isAbsolute(RationalNumber value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(RationalNumber value) {
        return value.getNumerator().signum() != 0 && value.getDenominator().signum() == 0;
    }

    public static boolean isNaN(RationalNumber value) {
        return value.getNumerator().signum() == 0 && value.getDenominator().signum() == 0;
    }

    public static boolean isSmall(double comparedTo, RationalNumber value) {
        return value.isSmall(comparedTo);
    }

    public static RationalNumber of(long numerator, long denominator) {
        BigInteger tmpDenominator;
        BigInteger tmpNumerator;
        long tmpGCD = RationalNumber.gcd(numerator, denominator);
        if (denominator < 0L) {
            tmpGCD = -tmpGCD;
        }
        if (tmpGCD != 1L) {
            tmpNumerator = BigInteger.valueOf(numerator / tmpGCD);
            tmpDenominator = BigInteger.valueOf(denominator / tmpGCD);
        } else {
            tmpNumerator = BigInteger.valueOf(numerator);
            tmpDenominator = BigInteger.valueOf(denominator);
        }
        return new RationalNumber(tmpNumerator, tmpDenominator);
    }

    public static RationalNumber valueOf(double value) {
        return RationalNumber.valueOf(BigDecimal.valueOf(value));
    }

    public static RationalNumber valueOf(Number number) {
        if (number != null) {
            BigInteger tmpDenominator;
            BigInteger tmpNumerator;
            if (number instanceof RationalNumber) {
                return (RationalNumber)number;
            }
            BigDecimal tmpBigDecimal = TypeUtils.toBigDecimal(number);
            int tmpScale = tmpBigDecimal.scale();
            if (tmpScale < 0) {
                tmpNumerator = tmpBigDecimal.unscaledValue().multiply(BigInteger.TEN.pow(-tmpScale));
                tmpDenominator = BigInteger.ONE;
            } else {
                BigInteger tmpDenom;
                BigInteger tmpNumer = tmpBigDecimal.unscaledValue();
                BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = BigInteger.TEN.pow(tmpScale));
                if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
                    tmpNumerator = tmpNumer.divide(tmpGCD);
                    tmpDenominator = tmpDenom.divide(tmpGCD);
                } else {
                    tmpNumerator = tmpNumer;
                    tmpDenominator = tmpDenom;
                }
            }
            return new RationalNumber(tmpNumerator, tmpDenominator);
        }
        return ZERO;
    }

    private static String toString(RationalNumber aNmbr) {
        StringBuilder retVal = new StringBuilder(LEFT);
        retVal.append(aNmbr.getNumerator());
        retVal.append(DIVIDE);
        retVal.append(aNmbr.getDenominator());
        return retVal.append(RIGHT).toString();
    }

    private RationalNumber() {
        this(BigInteger.ZERO, BigInteger.ONE);
    }

    private RationalNumber(BigInteger numerator, BigInteger denominator) {
        if (denominator.signum() >= 0) {
            this.myNumerator = numerator;
            this.myDenominator = denominator;
        } else {
            this.myNumerator = numerator.negate();
            this.myDenominator = denominator.negate();
        }
    }

    @Override
    public RationalNumber add(double arg) {
        return this.add(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber add(RationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myDenominator.equals(arg.getDenominator())) {
            return new RationalNumber(this.myNumerator.add(arg.getNumerator()), this.myDenominator);
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getDenominator()).add(arg.getNumerator().multiply(this.myDenominator));
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getDenominator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new RationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new RationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public int compareTo(RationalNumber reference) {
        return this.toBigDecimal().compareTo(reference.toBigDecimal());
    }

    @Override
    public RationalNumber conjugate() {
        return this;
    }

    @Override
    public RationalNumber divide(double arg) {
        return this.divide(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber divide(RationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myNumerator.equals(arg.getNumerator())) {
            return new RationalNumber(arg.getDenominator(), this.myDenominator);
        }
        if (this.myDenominator.equals(arg.getDenominator())) {
            return new RationalNumber(this.myNumerator, arg.getNumerator());
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getDenominator());
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getNumerator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new RationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new RationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public RationalNumber enforce(NumberContext context) {
        return RationalNumber.valueOf(this.toBigDecimal(context.getMathContext()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RationalNumber)) {
            return false;
        }
        RationalNumber other = (RationalNumber)obj;
        if (this.myDenominator == null ? other.myDenominator != null : !this.myDenominator.equals(other.myDenominator)) {
            return false;
        }
        return !(this.myNumerator == null ? other.myNumerator != null : !this.myNumerator.equals(other.myNumerator));
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public RationalNumber getNumber() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDenominator == null ? 0 : this.myDenominator.hashCode());
        result = 31 * result + (this.myNumerator == null ? 0 : this.myNumerator.hashCode());
        return result;
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public RationalNumber invert() {
        return new RationalNumber(this.myDenominator, this.myNumerator);
    }

    @Override
    public boolean isAbsolute() {
        return this.myNumerator.signum() >= 0 && this.myDenominator.signum() > 0;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return BigScalar.CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public RationalNumber multiply(double arg) {
        return this.multiply(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber multiply(RationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myNumerator.equals(arg.getDenominator())) {
            return new RationalNumber(arg.getNumerator(), this.myDenominator);
        }
        if (this.myDenominator.equals(arg.getNumerator())) {
            return new RationalNumber(this.myNumerator, arg.getDenominator());
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getNumerator());
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getDenominator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new RationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new RationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public RationalNumber negate() {
        return new RationalNumber(this.myNumerator.negate(), this.myDenominator);
    }

    @Override
    public double norm() {
        return PrimitiveFunction.ABS.invoke(this.doubleValue());
    }

    @Override
    public RationalNumber signum() {
        if (RationalNumber.isSmall(PrimitiveMath.ONE, this)) {
            return ZERO;
        }
        if (this.sign() == -1) {
            return ONE.negate();
        }
        return ONE;
    }

    @Override
    public RationalNumber subtract(double arg) {
        return this.subtract(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber subtract(RationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myDenominator.equals(arg.getDenominator())) {
            return new RationalNumber(this.myNumerator.subtract(arg.getNumerator()), this.myDenominator);
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getDenominator()).subtract(arg.getNumerator().multiply(this.myDenominator));
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getDenominator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new RationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new RationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = this.toBigDecimal(BigScalar.CONTEXT.getMathContext());
        }
        return this.myDecimal;
    }

    public String toString() {
        return RationalNumber.toString(this);
    }

    @Override
    public String toString(NumberContext context) {
        return RationalNumber.toString(this.enforce(context));
    }

    private int sign() {
        return this.myNumerator.signum() * this.myDenominator.signum();
    }

    private BigDecimal toBigDecimal(MathContext context) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.myDenominator), context);
    }

    BigInteger getDenominator() {
        return this.myDenominator;
    }

    BigInteger getNumerator() {
        return this.myNumerator;
    }
}

