/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class ComplexNumber
extends Number
implements Scalar<ComplexNumber>,
NumberContext.Enforceable<ComplexNumber>,
Access2D<Double>,
Access2D.Collectable<Double, PhysicalStore<Double>> {
    public static final Scalar.Factory<ComplexNumber> FACTORY = new Scalar.Factory<ComplexNumber>(){

        @Override
        public ComplexNumber cast(double value) {
            return ComplexNumber.valueOf(value);
        }

        @Override
        public ComplexNumber cast(Number number) {
            return ComplexNumber.valueOf(number);
        }

        public ComplexNumber convert(double value) {
            return ComplexNumber.valueOf(value);
        }

        public ComplexNumber convert(Number number) {
            return ComplexNumber.valueOf(number);
        }

        public ComplexNumber one() {
            return ONE;
        }

        public ComplexNumber zero() {
            return ZERO;
        }
    };
    public static final ComplexNumber I = new ComplexNumber(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    public static final ComplexNumber INFINITY = ComplexNumber.makePolar(Double.POSITIVE_INFINITY, PrimitiveMath.ZERO);
    public static final ComplexNumber NEG = ComplexNumber.valueOf(PrimitiveMath.NEG);
    public static final ComplexNumber ONE = ComplexNumber.valueOf(PrimitiveMath.ONE);
    public static final ComplexNumber TWO = ComplexNumber.valueOf(PrimitiveMath.TWO);
    public static final ComplexNumber ZERO = ComplexNumber.valueOf(PrimitiveMath.ZERO);
    private static final double ARGUMENT_TOLERANCE = PrimitiveMath.PI * PrimitiveScalar.CONTEXT.epsilon();
    private static final String LEFT = "(";
    private static final String MINUS = " - ";
    private static final String PLUS = " + ";
    private static final String RIGHT = "i)";
    public final double i;
    private final boolean myRealForSure;
    private final double myRealValue;

    public static boolean isAbsolute(ComplexNumber value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(ComplexNumber value) {
        return Double.isInfinite(value.doubleValue()) || Double.isInfinite(value.i);
    }

    public static boolean isNaN(ComplexNumber value) {
        return Double.isNaN(value.doubleValue()) || Double.isNaN(value.i);
    }

    public static boolean isReal(ComplexNumber value) {
        return value.isReal();
    }

    public static boolean isSmall(double comparedTo, ComplexNumber value) {
        return value.isSmall(comparedTo);
    }

    public static ComplexNumber makePolar(double norm, double phase) {
        double tmpSin;
        double tmpCos;
        double tmpStdPhase = phase % PrimitiveMath.TWO_PI;
        if (tmpStdPhase < PrimitiveMath.ZERO) {
            tmpStdPhase += PrimitiveMath.TWO_PI;
        }
        if (tmpStdPhase <= ARGUMENT_TOLERANCE) {
            return new ComplexNumber(norm);
        }
        if (PrimitiveFunction.ABS.invoke(tmpStdPhase - PrimitiveMath.PI) <= ARGUMENT_TOLERANCE) {
            return new ComplexNumber(-norm);
        }
        double tmpRe = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpCos = PrimitiveFunction.COS.invoke(tmpStdPhase)) != PrimitiveMath.ZERO) {
            tmpRe = norm * tmpCos;
        }
        double tmpIm = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpSin = PrimitiveFunction.SIN.invoke(tmpStdPhase)) != PrimitiveMath.ZERO) {
            tmpIm = norm * tmpSin;
        }
        return new ComplexNumber(tmpRe, tmpIm);
    }

    public static ComplexNumber of(double real, double imaginary) {
        if (PrimitiveScalar.CONTEXT.isSmall(real, imaginary)) {
            return new ComplexNumber(real);
        }
        return new ComplexNumber(real, imaginary);
    }

    public static ComplexNumber valueOf(double value) {
        return new ComplexNumber(value);
    }

    public static ComplexNumber valueOf(Number number) {
        if (number != null) {
            if (number instanceof ComplexNumber) {
                return (ComplexNumber)number;
            }
            return new ComplexNumber(number.doubleValue());
        }
        return ZERO;
    }

    private ComplexNumber() {
        this(PrimitiveMath.ZERO);
    }

    private ComplexNumber(double real) {
        this.myRealValue = real;
        this.myRealForSure = true;
        this.i = PrimitiveMath.ZERO;
    }

    private ComplexNumber(double real, double imaginary) {
        this.myRealValue = real;
        this.myRealForSure = false;
        this.i = imaginary;
    }

    @Override
    public ComplexNumber add(ComplexNumber arg) {
        return new ComplexNumber(this.myRealValue + arg.doubleValue(), this.i + arg.i);
    }

    @Override
    public ComplexNumber add(double arg) {
        return new ComplexNumber(this.myRealValue + arg, this.i);
    }

    @Override
    public int compareTo(ComplexNumber reference) {
        int retVal = 0;
        retVal = Double.compare(this.norm(), reference.norm());
        if (retVal == 0 && (retVal = Double.compare(this.doubleValue(), reference.doubleValue())) == 0) {
            retVal = Double.compare(this.i, reference.i);
        }
        return retVal;
    }

    @Override
    public ComplexNumber conjugate() {
        return new ComplexNumber(this.myRealValue, -this.i);
    }

    @Override
    public long count() {
        return 4L;
    }

    @Override
    public long countColumns() {
        return 2L;
    }

    @Override
    public long countRows() {
        return 2L;
    }

    @Override
    public ComplexNumber divide(ComplexNumber arg) {
        double tmpRe = arg.doubleValue();
        double tmpIm = arg.i;
        if (PrimitiveFunction.ABS.invoke(tmpRe) > PrimitiveFunction.ABS.invoke(tmpIm)) {
            double r = tmpIm / tmpRe;
            double d = tmpRe + r * tmpIm;
            return new ComplexNumber((this.myRealValue + r * this.i) / d, (this.i - r * this.myRealValue) / d);
        }
        double r = tmpRe / tmpIm;
        double d = tmpIm + r * tmpRe;
        return new ComplexNumber((r * this.myRealValue + this.i) / d, (r * this.i - this.myRealValue) / d);
    }

    @Override
    public ComplexNumber divide(double arg) {
        return new ComplexNumber(this.myRealValue / arg, this.i / arg);
    }

    @Override
    public double doubleValue() {
        return this.myRealValue;
    }

    @Override
    public double doubleValue(long index) {
        switch ((int)index) {
            case 0: {
                return this.myRealValue;
            }
            case 1: {
                return this.i;
            }
            case 2: {
                return -this.i;
            }
            case 3: {
                return this.myRealValue;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row == col) {
            return this.myRealValue;
        }
        if (row == 1L) {
            return this.i;
        }
        if (col == 1L) {
            return -this.i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public ComplexNumber enforce(NumberContext context) {
        double tmpRe = context.enforce(this.myRealValue);
        double tmpIm = context.enforce(this.i);
        return new ComplexNumber(tmpRe, tmpIm);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplexNumber)) {
            return false;
        }
        ComplexNumber other = (ComplexNumber)obj;
        if (Double.doubleToLongBits(this.myRealValue) != Double.doubleToLongBits(other.myRealValue)) {
            return false;
        }
        return Double.doubleToLongBits(this.i) == Double.doubleToLongBits(other.i);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public Double get(long index) {
        return this.doubleValue(index);
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    public double getArgument() {
        return this.phase();
    }

    public double getImaginary() {
        return this.i;
    }

    public double getModulus() {
        return this.norm();
    }

    @Override
    public ComplexNumber getNumber() {
        return this;
    }

    public double getReal() {
        return this.doubleValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.myRealValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.i);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public ComplexNumber invert() {
        return ComplexNumber.makePolar(PrimitiveMath.ONE / this.norm(), -this.phase());
    }

    @Override
    public boolean isAbsolute() {
        if (this.myRealForSure) {
            return this.myRealValue >= PrimitiveMath.ZERO;
        }
        return !PrimitiveScalar.CONTEXT.isDifferent(this.norm(), this.myRealValue);
    }

    public boolean isReal() {
        return this.myRealForSure || PrimitiveScalar.CONTEXT.isSmall(this.myRealValue, this.i);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.CONTEXT.isSmall(comparedTo, this.norm());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public ComplexNumber multiply(ComplexNumber arg) {
        double tmpRe = arg.doubleValue();
        double tmpIm = arg.i;
        return new ComplexNumber(this.myRealValue * tmpRe - this.i * tmpIm, this.myRealValue * tmpIm + this.i * tmpRe);
    }

    @Override
    public ComplexNumber multiply(double arg) {
        return new ComplexNumber(this.myRealValue * arg, this.i * arg);
    }

    @Override
    public ComplexNumber negate() {
        return new ComplexNumber(-this.myRealValue, -this.i);
    }

    @Override
    public double norm() {
        return PrimitiveFunction.HYPOT.invoke(this.myRealValue, this.i);
    }

    public double phase() {
        return Math.atan2(this.i, this.myRealValue);
    }

    @Override
    public ComplexNumber signum() {
        if (ComplexNumber.isSmall(PrimitiveMath.ONE, this)) {
            return ComplexNumber.makePolar(PrimitiveMath.ONE, PrimitiveMath.ZERO);
        }
        return ComplexNumber.makePolar(PrimitiveMath.ONE, this.phase());
    }

    @Override
    public ComplexNumber subtract(ComplexNumber arg) {
        return new ComplexNumber(this.myRealValue - arg.doubleValue(), this.i - arg.i);
    }

    @Override
    public ComplexNumber subtract(double arg) {
        return new ComplexNumber(this.myRealValue - arg, this.i);
    }

    @Override
    public void supplyTo(PhysicalStore<Double> receiver) {
        receiver.set(0L, this.myRealValue);
        receiver.set(1L, this.i);
        receiver.set(2L, -this.i);
        receiver.set(3L, this.myRealValue);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.doubleValue(), MathContext.DECIMAL64);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder(LEFT);
        double tmpRe = this.myRealValue;
        double tmpIm = this.i;
        retVal.append(Double.toString(tmpRe));
        if (tmpIm < PrimitiveMath.ZERO) {
            retVal.append(MINUS);
        } else {
            retVal.append(PLUS);
        }
        retVal.append(Double.toString(PrimitiveFunction.ABS.invoke(tmpIm)));
        return retVal.append(RIGHT).toString();
    }

    @Override
    public String toString(NumberContext context) {
        StringBuilder retVal = new StringBuilder(LEFT);
        BigDecimal tmpRe = context.enforce(new BigDecimal(this.myRealValue, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpIm = context.enforce(new BigDecimal(this.i, PrimitiveScalar.CONTEXT.getMathContext()));
        retVal.append(tmpRe.toString());
        if (tmpIm.signum() < 0) {
            retVal.append(MINUS);
        } else {
            retVal.append(PLUS);
        }
        retVal.append(tmpIm.abs().toString());
        return retVal.append(RIGHT).toString();
    }
}

