/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.RandomUtils;

public class Normal
extends AbstractContinuous {
    private static final long serialVersionUID = 7164712313114018919L;
    private final double myLocation;
    private final double myScale;

    public Normal() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public Normal(double aLocation, double aScale) {
        this.myLocation = aLocation;
        this.myScale = aScale;
    }

    @Override
    public double getDistribution(double value) {
        return (PrimitiveMath.ONE + RandomUtils.erf((value - this.myLocation) / (this.myScale * PrimitiveMath.SQRT_TWO))) / PrimitiveMath.TWO;
    }

    @Override
    public double getExpected() {
        return this.myLocation;
    }

    @Override
    public double getProbability(double value) {
        double tmpVal = (value - this.myLocation) / this.myScale;
        return PrimitiveFunction.EXP.invoke(tmpVal * tmpVal / -PrimitiveMath.TWO) / (this.myScale * PrimitiveMath.SQRT_TWO_PI);
    }

    @Override
    public double getQuantile(double probality) {
        this.checkProbabilty(probality);
        return this.myScale * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(PrimitiveMath.TWO * probality - PrimitiveMath.ONE) + this.myLocation;
    }

    @Override
    public double getStandardDeviation() {
        return this.myScale;
    }

    @Override
    protected double generate() {
        return this.random().nextGaussian() * this.myScale + this.myLocation;
    }
}

