/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.type.IndexSelector;

abstract class ActiveSetSolver
extends ConstrainedSolver {
    final IndexSelector myActivator;
    int myConstraintToInclude = -1;
    MatrixStore<Double> myInvQC;
    final PrimitiveDenseStore myIterationL;
    final PrimitiveDenseStore myIterationX;

    ActiveSetSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        int tmpCountVariables = this.countVariables();
        int tmpCountInequalityConstraints = this.countInequalityConstraints();
        int tmpCountEqualityConstraints = this.countEqualityConstraints();
        this.myActivator = new IndexSelector(tmpCountInequalityConstraints);
        this.myIterationL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountEqualityConstraints + tmpCountInequalityConstraints, 1L);
        this.myIterationX = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountVariables, 1L);
    }

    public int countExcluded() {
        return this.myActivator.countExcluded();
    }

    public int countIncluded() {
        return this.myActivator.countIncluded();
    }

    public int[] getExcluded() {
        return this.myActivator.getExcluded();
    }

    public int[] getIncluded() {
        return this.myActivator.getIncluded();
    }

    public int getLastExcluded() {
        return this.myActivator.getLastExcluded();
    }

    public int getLastIncluded() {
        return this.myActivator.getLastIncluded();
    }

    protected boolean checkFeasibility(boolean onlyExcluded) {
        double tmpRHS;
        double tmpBody;
        int i;
        MatrixStore<Double> tmpAIX;
        boolean retVal = true;
        if (!onlyExcluded) {
            if (this.hasEqualityConstraints()) {
                MatrixStore<Double> tmpAEX = this.getAEX();
                MatrixStore<Double> tmpBE = this.getBE();
                int i2 = 0;
                while (retVal && (long)i2 < tmpBE.countRows()) {
                    if (this.options.slack.isDifferent(tmpBE.doubleValue(i2), tmpAEX.doubleValue(i2))) {
                        retVal = false;
                    }
                    ++i2;
                }
            }
            if (this.hasInequalityConstraints() && this.myActivator.countIncluded() > 0) {
                int[] tmpIncluded = this.myActivator.getIncluded();
                tmpAIX = this.getAIX(tmpIncluded);
                MatrixStore<Double> tmpBI = this.getBI(tmpIncluded);
                for (i = 0; retVal && i < tmpIncluded.length; ++i) {
                    tmpBody = tmpAIX.doubleValue(i);
                    if (!(tmpBody > (tmpRHS = tmpBI.doubleValue(i))) || !this.options.slack.isDifferent(tmpRHS, tmpBody)) continue;
                    retVal = false;
                }
            }
        }
        if (this.hasInequalityConstraints() && this.myActivator.countExcluded() > 0) {
            int[] tmpExcluded = this.myActivator.getExcluded();
            tmpAIX = this.getAIX(tmpExcluded);
            MatrixStore<Double> tmpBI = this.getBI(tmpExcluded);
            for (i = 0; retVal && i < tmpExcluded.length; ++i) {
                tmpBody = tmpAIX.doubleValue(i);
                if (!(tmpBody > (tmpRHS = tmpBI.doubleValue(i))) || !this.options.slack.isDifferent(tmpRHS, tmpBody)) continue;
                retVal = false;
            }
        }
        return retVal;
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return super.extractSolution();
    }

    @Override
    protected final MatrixStore<Double> getIterationKKT() {
        return this.getIterationKKT(this.myActivator.getIncluded());
    }

    protected final MatrixStore<Double> getIterationKKT(int[] included) {
        PhysicalStore<Double> tmpIterationQ = this.getIterationQ();
        MatrixStore<Double> tmpIterationA = this.getIterationA(included);
        return tmpIterationQ.logical().right(new MatrixStore[]{tmpIterationA.transpose()}).below(tmpIterationA).get();
    }

    @Override
    protected final MatrixStore<Double> getIterationRHS() {
        return this.getIterationRHS(this.myActivator.getIncluded());
    }

    protected final MatrixStore<Double> getIterationRHS(int[] included) {
        MatrixStore<Double> tmpIterationC = this.getIterationC();
        MatrixStore<Double> tmpIterationB = this.getIterationB(included);
        return tmpIterationC.logical().below(tmpIterationB).get();
    }

    @Override
    protected final boolean initialise(Optimisation.Result kickStarter) {
        boolean tmpUsableKickStarter;
        super.initialise(kickStarter);
        this.getQ();
        MatrixStore<Double> tmpC = this.getC();
        MatrixStore<Double> tmpAE = this.getAE();
        MatrixStore<Double> tmpBE = this.getBE();
        MatrixStore<Double> tmpAI = this.getAI();
        MatrixStore<Double> tmpBI = this.getBI();
        int tmpNumVars = (int)tmpC.countRows();
        int tmpNumEqus = tmpAE != null ? (int)tmpAE.countRows() : 0;
        PhysicalStore<Double> tmpX = this.getX();
        this.myActivator.excludeAll();
        boolean tmpFeasible = false;
        boolean bl = tmpUsableKickStarter = kickStarter != null && kickStarter.getState().isApproximate();
        if (tmpUsableKickStarter) {
            this.fillX(kickStarter);
            tmpFeasible = this.checkFeasibility(false);
        }
        if (!tmpFeasible) {
            tmpFeasible = this.solveLP(tmpC, tmpAE, tmpBE, tmpAI, tmpBI);
        }
        if (tmpFeasible) {
            this.setState(Optimisation.State.FEASIBLE);
            this.initSolution(tmpBI, tmpNumVars, tmpNumEqus);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.resetX();
        }
        if (this.isDebug()) {
            this.debug("Initial solution: {}", tmpX.copy().asList());
            if (tmpAE != null) {
                this.debug("Initial E-slack: {}", this.getSE().copy().asList());
            }
            if (tmpAI != null) {
                this.debug("Initial I-included-slack: {}", this.getSI(this.myActivator.getIncluded()).copy().asList());
                this.debug("Initial I-excluded-slack: {}", this.getSI(this.myActivator.getExcluded()).copy().asList());
            }
        }
        return this.getState().isFeasible();
    }

    @Override
    protected final boolean needsAnotherIteration() {
        if (this.isDebug()) {
            this.debug("\nNeedsAnotherIteration?", new Object[0]);
            this.debug(this.myActivator.toString(), new Object[0]);
        }
        int tmpToInclude = -1;
        int tmpToExclude = -1;
        if (this.hasInequalityConstraints() && (tmpToInclude = this.suggestConstraintToInclude()) == -1) {
            tmpToExclude = this.suggestConstraintToExclude();
        }
        if (this.isDebug()) {
            this.debug("Suggested to include: {}", tmpToInclude);
            this.debug("Suggested to exclude: {}", tmpToExclude);
        }
        if (tmpToExclude == -1) {
            if (tmpToInclude == -1) {
                this.setState(Optimisation.State.OPTIMAL);
                return false;
            }
            this.myActivator.include(tmpToInclude);
            this.setState(Optimisation.State.APPROXIMATE);
            return true;
        }
        if (tmpToInclude == -1) {
            this.excludeAndRemove(tmpToExclude);
            this.setState(Optimisation.State.APPROXIMATE);
            return true;
        }
        this.excludeAndRemove(tmpToExclude);
        this.myActivator.include(tmpToInclude);
        this.setState(Optimisation.State.APPROXIMATE);
        return true;
    }

    protected int suggestConstraintToExclude() {
        double tmpVal;
        int retVal = -1;
        int[] tmpIncluded = this.myActivator.getIncluded();
        int tmpLastIncluded = this.myActivator.getLastIncluded();
        int tmpIndexOfLast = -1;
        double tmpMin = Double.POSITIVE_INFINITY;
        Object tmpLI = this.myIterationL.logical().offsets(this.countEqualityConstraints(), 0).row(tmpIncluded).get();
        if (this.isDebug() && tmpLI.count() > 0L) {
            this.debug("Looking for the largest negative lagrange multiplier among these: {}.", tmpLI.copy().asList());
        }
        int i = 0;
        while ((long)i < tmpLI.countRows()) {
            if (tmpIncluded[i] != tmpLastIncluded) {
                tmpVal = tmpLI.doubleValue(i, 0L);
                if (tmpVal < PrimitiveMath.ZERO && tmpVal < tmpMin && !this.options.solution.isZero(tmpVal)) {
                    tmpMin = tmpVal;
                    retVal = i;
                    if (this.isDebug()) {
                        this.debug("Best so far: {} @ {} ({}).", tmpMin, retVal, tmpIncluded[i]);
                    }
                }
            } else {
                tmpIndexOfLast = i;
            }
            ++i;
        }
        if (retVal < 0 && tmpIndexOfLast >= 0 && (tmpVal = tmpLI.doubleValue(tmpIndexOfLast, 0L)) < PrimitiveMath.ZERO && tmpVal < tmpMin && !this.options.solution.isZero(tmpVal)) {
            tmpMin = tmpVal;
            retVal = tmpIndexOfLast;
            if (this.isDebug()) {
                this.debug("Only the last included needs to be excluded: {} @ {} ({}).", tmpMin, retVal, tmpIncluded[retVal]);
            }
        }
        return retVal >= 0 ? tmpIncluded[retVal] : retVal;
    }

    protected int suggestConstraintToInclude() {
        return this.myConstraintToInclude;
    }

    abstract void excludeAndRemove(int var1);

    @Override
    final MatrixStore<Double> getIterationA() {
        return this.getIterationA(this.myActivator.getIncluded());
    }

    abstract MatrixStore<Double> getIterationA(int[] var1);

    @Override
    final MatrixStore<Double> getIterationB() {
        return this.getIterationB(this.myActivator.getIncluded());
    }

    abstract MatrixStore<Double> getIterationB(int[] var1);

    @Override
    final MatrixStore<Double> getIterationC() {
        return this.getC();
    }

    MatrixStore<Double> getIterationL(int[] included) {
        int tmpCountE = this.countEqualityConstraints();
        Object tmpLI = this.myIterationL.logical().offsets(tmpCountE, 0).row(included).get();
        return this.myIterationL.logical().limits(tmpCountE, 1).below(new MatrixStore[]{tmpLI}).get();
    }

    final void handleSubsolution(boolean solved, PrimitiveDenseStore iterationSolution, int[] included) {
        if (solved) {
            double tmpNormStepX;
            double tmpNormCurrentX;
            iterationSolution.fillMatching((Access1D<Double>)iterationSolution, (BinaryFunction<Double>)PrimitiveFunction.SUBTRACT, this.getX());
            if (this.isDebug()) {
                this.debug("Current: {}", this.getX().asList());
                this.debug("Step: {}", iterationSolution.copy().asList());
            }
            if (!(this.options.solution.isSmall(tmpNormCurrentX = ((Double)this.getX().aggregateAll(Aggregator.NORM2)).doubleValue(), tmpNormStepX = iterationSolution.aggregateAll(Aggregator.NORM2).doubleValue()) || !this.options.solution.isSmall(PrimitiveMath.ONE, tmpNormCurrentX) && this.options.solution.isSmall(tmpNormStepX, tmpNormCurrentX))) {
                double tmpStepLength = PrimitiveMath.ONE;
                int[] tmpExcluded = this.myActivator.getExcluded();
                if (tmpExcluded.length > 0) {
                    MatrixStore<Double> tmpNumer = this.getSI(tmpExcluded);
                    MatrixStore<PrimitiveDenseStore> tmpDenom = this.getAI().logical().row(tmpExcluded).get().multiply(iterationSolution);
                    if (this.isDebug()) {
                        PhysicalStore<Double> tmpStepLengths = tmpNumer.copy();
                        tmpStepLengths.modifyMatching(PrimitiveFunction.DIVIDE, tmpDenom);
                        this.debug("Numer/slack: {}", tmpNumer.copy().asList());
                        this.debug("Denom/chang: {}", tmpDenom.copy().asList());
                        this.debug("Looking for the largest possible step length (smallest positive scalar) among these: {}).", tmpStepLengths.asList());
                    }
                    for (int i = 0; i < tmpExcluded.length; ++i) {
                        double tmpVal;
                        double tmpN = tmpNumer.doubleValue(i);
                        double tmpD = tmpDenom.doubleValue(i);
                        double d = tmpVal = this.options.slack.isSmall(tmpD, tmpN) ? PrimitiveMath.ZERO : tmpN / tmpD;
                        if (tmpD > PrimitiveMath.ZERO && tmpVal >= PrimitiveMath.ZERO && tmpVal < tmpStepLength && !this.options.solution.isSmall(tmpNormStepX, tmpD)) {
                            tmpStepLength = tmpVal;
                            this.myConstraintToInclude = tmpExcluded[i];
                            if (!this.isDebug()) continue;
                            this.debug("Best so far: {} @ {} ({}).", tmpStepLength, i, this.myConstraintToInclude);
                            continue;
                        }
                        if (Double.compare(tmpVal, PrimitiveMath.ZERO) != 0 || !this.isDebug()) continue;
                        this.debug("Zero, but still not good...", new Object[0]);
                        this.debug("Numer/slack: {}", tmpN);
                        this.debug("Denom/chang: {}", tmpD);
                        this.debug("Small:       {}", this.options.solution.isSmall(tmpNormStepX, tmpD));
                    }
                }
                if (tmpStepLength > PrimitiveMath.ZERO) {
                    iterationSolution.axpy(tmpStepLength, this.getX());
                } else if (this.myConstraintToInclude >= 0 && this.myActivator.getLastExcluded() == this.myConstraintToInclude && this.myActivator.getLastIncluded() == this.myConstraintToInclude) {
                    this.myConstraintToInclude = -1;
                }
                this.setState(Optimisation.State.APPROXIMATE);
            } else if (this.isDebug()) {
                if (this.isDebug()) {
                    this.debug("Step too small!", new Object[0]);
                }
                this.setState(Optimisation.State.FEASIBLE);
            }
        } else if (included.length >= 1) {
            this.shrink();
            this.performIteration();
        } else if (!this.myCholesky.isSolvable()) {
            double tmpLargestQ = (Double)this.getIterationQ().aggregateAll(Aggregator.LARGEST);
            double tmpLargestC = this.getC().aggregateAll(Aggregator.LARGEST);
            double tmpLargest = PrimitiveFunction.MAX.invoke(tmpLargestQ, tmpLargestC);
            this.getIterationQ().modifyDiagonal(0L, 0L, PrimitiveFunction.ADD.second(tmpLargest * PrimitiveFunction.SQRT.invoke(PrimitiveMath.MACHINE_EPSILON)));
            this.myCholesky.compute(this.getIterationQ());
            this.myIterationL.modifyAll(arg -> {
                if (Double.isFinite(arg)) {
                    return arg;
                }
                return PrimitiveMath.ZERO;
            });
            this.initSolution(this.getBI(), this.countVariables(), this.countEqualityConstraints());
            this.performIteration();
        } else if (this.checkFeasibility(false)) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
        }
        if (this.isDebug()) {
            this.debug("Post iteration", new Object[0]);
            this.debug("\tSolution: {}", this.getX().copy().asList());
            this.debug("\tL: {}", this.myIterationL.asList());
            if (this.getAE() != null && this.getAE().count() > 0L) {
                this.debug("\tE-slack: {}", this.getSE().copy().asList());
                if (!this.options.slack.isZero((Double)this.getSE().aggregateAll(Aggregator.LARGEST))) {
                    // empty if block
                }
            }
            if (this.getAI() != null && this.getAI().count() > 0L) {
                if (included.length != 0) {
                    this.debug("\tI-included-slack: {}", this.getSI(included).copy().asList());
                    if (!this.options.slack.isZero(this.getSI(included).aggregateAll(Aggregator.LARGEST))) {
                        // empty if block
                    }
                }
                if (this.myActivator.getExcluded().length != 0) {
                    this.debug("\tI-excluded-slack: {}", this.getSI(this.myActivator.getExcluded()).copy().asList());
                    if (this.getSI(this.myActivator.getExcluded()).aggregateAll(Aggregator.MAXIMUM) < PrimitiveMath.ZERO) {
                        // empty if block
                    }
                }
            }
        }
    }

    abstract void initSolution(MatrixStore<Double> var1, int var2, int var3);

    final void shrink() {
        int[] tmpIncluded = this.myActivator.getIncluded();
        int tmpToExclude = tmpIncluded[0];
        double tmpMaxWeight = PrimitiveMath.ZERO;
        Object tmpLI = this.myIterationL.logical().offsets(this.countEqualityConstraints(), 0).row(tmpIncluded).get();
        for (int i = 0; i < tmpIncluded.length; ++i) {
            double tmpValue = tmpLI.doubleValue(i);
            double tmpWeight = PrimitiveFunction.ABS.invoke(tmpValue) * PrimitiveFunction.MAX.invoke(-tmpValue, PrimitiveMath.ONE);
            if (!(tmpWeight > tmpMaxWeight)) continue;
            tmpMaxWeight = tmpWeight;
            tmpToExclude = tmpIncluded[i];
        }
        this.excludeAndRemove(tmpToExclude);
    }

    final boolean solveLP(MatrixStore<Double> convexC, MatrixStore<Double> convexAE, MatrixStore<Double> convexBE, MatrixStore<Double> convexAI, MatrixStore<Double> convexBI) {
        LinearSolver tmpLinearSolver;
        Optimisation.Result tmpLinearResult;
        int i;
        int tmpNumVars = this.countVariables();
        int tmpNumEqus = this.countEqualityConstraints();
        int tmpNumInes = this.countInequalityConstraints();
        Object tmpLinearC = convexC.negate().logical().below(convexC).below(tmpNumInes).get();
        LinearSolver.Builder tmpLinearBuilder = LinearSolver.getBuilder((MatrixStore<Double>)tmpLinearC);
        Object tmpAEpart = null;
        Object tmpBEpart = null;
        if (tmpNumEqus > 0) {
            tmpAEpart = convexAE.logical().right(new MatrixStore[]{convexAE.negate()}).right(tmpNumInes).get();
            tmpBEpart = convexBE;
        }
        if (tmpNumInes > 0) {
            Object tmpAIpart = convexAI.logical().right(new MatrixStore[]{convexAI.negate()}).right(new MatrixStore[]{MatrixStore.PRIMITIVE.makeIdentity(tmpNumInes).get()}).get();
            MatrixStore<Double> tmpBIpart = convexBI;
            if (tmpAEpart != null) {
                tmpAEpart = tmpAEpart.logical().below(new MatrixStore[]{tmpAIpart}).get();
                tmpBEpart = tmpBEpart.logical().below(tmpBIpart).get();
            } else {
                tmpAEpart = tmpAIpart;
                tmpBEpart = tmpBIpart;
            }
        }
        if (tmpAEpart != null) {
            PhysicalStore<Double> tmpLinearAE = tmpAEpart.copy();
            PhysicalStore<Double> tmpLinearBE = tmpBEpart.copy();
            i = 0;
            while ((long)i < tmpLinearBE.countRows()) {
                if (tmpLinearBE.doubleValue(i) < 0.0) {
                    tmpLinearAE.modifyRow(i, 0L, PrimitiveFunction.NEGATE);
                    tmpLinearBE.modifyRow(i, 0L, PrimitiveFunction.NEGATE);
                }
                ++i;
            }
            tmpLinearBuilder.equalities(tmpLinearAE, tmpLinearBE);
        }
        if ((tmpLinearResult = (tmpLinearSolver = tmpLinearBuilder.build(this.options)).solve()).getState().isFeasible()) {
            for (i = 0; i < tmpNumVars; ++i) {
                this.setX(i, tmpLinearResult.doubleValue(i) - tmpLinearResult.doubleValue(tmpNumVars + i));
            }
            double[] tmpResidual = tmpLinearSolver.getDualVariables();
            if (tmpResidual.length != this.countEqualityConstraints() + this.countInequalityConstraints()) {
                throw new IllegalStateException();
            }
            for (int i2 = 0; i2 < tmpResidual.length; ++i2) {
                this.myIterationL.set((long)i2, tmpResidual[i2]);
            }
            return true;
        }
        return false;
    }
}

